/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.attr;

import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;

public class OtherHashAlgAndValue
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public AlgorithmIdentifier getHashAlgorithm() {
        ASN1ValueHolder o = this.getValueHolder().getChild(0);
        return (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(o);
    }

    public boolean isZeroHash() {
        byte[] hashValue = this.getHashValue();
        for (int i = 0; i < hashValue.length; ++i) {
            if ((hashValue[0] & 0xFF) == 0) continue;
            return false;
        }
        return true;
    }

    public byte[] getHashValue() {
        DEROctetString hash = this.getValueHolder().getChild(1).toDEROctetString();
        return hash.getOctets();
    }

    public void setHashAlgorithm(AlgorithmIdentifier algorithm) {
        this.getValueHolder().setChild(0, algorithm);
    }

    public void setHashValue(byte[] hashValue) {
        this.getValueHolder().setChild(1, (ASN1Encodable)new DEROctetString(hashValue));
    }

    public void setHashValueZero() {
        this.setHashValue(new byte[]{0});
    }

    public static class Factory
    extends ASN1Based.Factory<OtherHashAlgAndValue> {
    }
}

