/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.attr;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.attr.AttributeCertificate;
import java.util.ArrayList;
import java.util.List;

public class CertifiedAttributesV2
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public void addAttributeCertificate(AttributeCertificate attributeCertificate) {
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 0, attributeCertificate);
        this.getValueHolder().addChild(tagged);
    }

    protected List<ASN1ValueHolder> getAllTaggedUntag(int tag, boolean explicit) {
        ArrayList<ASN1ValueHolder> result = new ArrayList<ASN1ValueHolder>();
        for (int i = 0; i < this.getValueHolder().size(); ++i) {
            ASN1TaggedHolder vh = (ASN1TaggedHolder)this.getValueHolder().getChild(i);
            vh.setExplicit(true);
            if (vh.getTagNo() != tag) continue;
            result.add(vh.getChild());
        }
        return result;
    }

    public List<AttributeCertificate> getAttributeCertificates() {
        ArrayList<AttributeCertificate> result = new ArrayList<AttributeCertificate>();
        for (ASN1ValueHolder vh : this.getAllTaggedUntag(0, true)) {
            result.add((AttributeCertificate)AttributeCertificate.FACTORY.create(vh));
        }
        return result;
    }

    public static class Factory
    extends ASN1Based.Factory<CertifiedAttributesV2> {
    }
}

