/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.attr;

import de.intarsys.asn1.cms.attr.SignaturePolicyId;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1ValueHolder;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;

public class AttributeSignaturePolicyIdentifier
extends Attribute {
    public static final String ID = "1.2.840.113549.1.9.16.2.15";
    public static final Factory FACTORY = new Factory();

    @Override
    protected void initializeAfterCreateNew() {
        super.initializeAfterCreateNew();
        this.setAttrType(ID);
    }

    public SignaturePolicyId[] getSignaturePolicyIdentifiers() {
        ArrayList<SignaturePolicyId> signaturePolicyIds = new ArrayList<SignaturePolicyId>();
        for (ASN1ValueHolder attrValue : this.getAttrValues()) {
            if (!(attrValue.getValue() instanceof ASN1Sequence)) continue;
            SignaturePolicyId signaturePolicyId = (SignaturePolicyId)SignaturePolicyId.FACTORY.create(attrValue);
            signaturePolicyIds.add(signaturePolicyId);
        }
        return signaturePolicyIds.toArray(new SignaturePolicyId[signaturePolicyIds.size()]);
    }

    public boolean hasImpliedPolicy() {
        for (ASN1ValueHolder attrValue : this.getAttrValues()) {
            if (!(attrValue.getValue() instanceof ASN1Null)) continue;
            return true;
        }
        return false;
    }

    public void addSignaturePolicyId(SignaturePolicyId signaturePolicyId) {
        this.addAttrValue(signaturePolicyId);
    }

    public void addSignaturePolicyImplied() {
        this.addAttrValue((ASN1Encodable)DERNull.INSTANCE);
    }

    public static class Factory
    extends Attribute.Factory<AttributeSignaturePolicyIdentifier> {
        @Override
        public String getAttributeType() {
            return AttributeSignaturePolicyIdentifier.ID;
        }
    }
}

