/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.IssuerAndSerialNumber;
import de.intarsys.asn1.cms.RecipientKeyIdentifier;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;

public class KeyAgreeRecipientIdentifier
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        if (!this.isIssuerAndSerialNumber()) {
            return null;
        }
        return (IssuerAndSerialNumber)IssuerAndSerialNumber.FACTORY.create(this.getValueHolder());
    }

    public RecipientKeyIdentifier getRecipientKeyIdentifier() {
        if (!this.isRecipientKeyIdentifier()) {
            return null;
        }
        this.getValueHolder().setExplicit(false);
        return (RecipientKeyIdentifier)RecipientKeyIdentifier.FACTORY.create(this.getValueHolder().getChild());
    }

    public boolean isIssuerAndSerialNumber() {
        return !this.getValueHolder().isTagged();
    }

    public boolean isRecipientKeyIdentifier() {
        if (!this.getValueHolder().isTagged()) {
            return false;
        }
        return ((ASN1TaggedHolder)this.getValueHolder()).getTagNo() == 0;
    }

    public void setIssuerAndSerialNumber(IssuerAndSerialNumber issuerAndSerial) {
        this.setValueHolder(issuerAndSerial.getValueHolder());
    }

    public void setRecipientKeyIdentifier(RecipientKeyIdentifier recipientKeyIdentifier) {
        this.setValueHolder(new ASN1TaggedHolder(false, 0, recipientKeyIdentifier));
    }

    public static class Factory
    extends ASN1Based.Factory<KeyAgreeRecipientIdentifier> {
    }
}

