/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ScalarHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;

public class Digest
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public static Digest create(byte[] digest) {
        Digest result = (Digest)FACTORY.createNew();
        result.setBytes(digest);
        return result;
    }

    public Digest copy() throws IOException {
        return (Digest)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    public byte[] getBytes() {
        return this.getValueHolder().toDEROctetString().getOctets();
    }

    public void setBytes(byte[] signature) {
        this.getValueHolder().setValue((ASN1Primitive)new DEROctetString(signature));
    }

    public static class Factory
    extends ASN1Based.Factory<Digest> {
        @Override
        protected ASN1ValueHolder basicCreateValueHolder() {
            return new ASN1ScalarHolder();
        }
    }
}

