/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging.logback.logstash;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.core.JsonGenerator;
import de.intarsys.tools.valueholder.INamedValue;
import java.io.IOException;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.fieldnames.LogstashFieldNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgumentsJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    private static final Logger Log = LoggerFactory.getLogger(ArgumentsJsonProvider.class);

    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getArguments());
    }

    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        Object[] args = event.getArgumentArray();
        if (args == null || args.length == 0) {
            return;
        }
        boolean hasWrittenFieldName = false;
        for (Object arg : args) {
            if (!(arg instanceof INamedValue)) continue;
            if (!hasWrittenFieldName && this.getFieldName() != null) {
                generator.writeObjectFieldStart(this.getFieldName());
                hasWrittenFieldName = true;
            }
            INamedValue namedValue = (INamedValue)arg;
            generator.writeFieldName(String.valueOf(namedValue.getName()));
            try {
                generator.writeObject(namedValue.get());
            }
            catch (IOException e) {
                Log.warn("failed to serialize {}", namedValue.get());
                generator.writeObject((Object)"<error>");
            }
        }
        if (hasWrittenFieldName) {
            generator.writeEndObject();
        }
    }
}

