/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.license.LicenseAccount;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseProperty;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;

public class LicensePropertyUnitPerSession
extends LicensePropertyUnit {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    protected void deposit(LicenseAccount account, int amount) throws LicenseException {
        LicensePropertyUnitPerSession.incrementSpentTokens(account, -amount);
    }

    @Override
    public String getId() {
        return "session";
    }

    @Override
    public String getLabel() {
        return Msg.getString("LicensePropertyUnitPerSession.Label", new Object[0]);
    }

    @Override
    protected void withdraw(LicenseAccount account, LicenseProperty property, int amount) throws LicenseException {
        int maxTokens = this.getLimit(property, account);
        if (maxTokens >= 0 && LicensePropertyUnitPerSession.getSpentTokens(account) >= maxTokens) {
            this.handleRestrictionExceeded(account, property, maxTokens, LicensePropertyUnitPerSession.getSpentTokens(account));
        }
        LicensePropertyUnitPerSession.incrementSpentTokens(account, amount);
    }
}

