/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.suis.validator.rest.to;

import ch.admin.suis.validator.rest.to.AdditionalInfosTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.intarsys.tools.hex.HexTools;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;

public class SignatureTO {
    private String client;
    private byte[] signatureContent;
    private Date signatureDate;
    private byte[] signatureDigest;
    private String signatureName;
    private Integer signaturePosition;
    private SignatureType type;
    private ChangeLevel changeLevel = ChangeLevel.UNDEFINED;
    private AdditionalInfosTO additionalInfos;
    @JsonProperty
    private boolean containsCrucialChanges;
    @JsonProperty
    private boolean containsVisualChanges;

    public boolean containsCrucialChanges() {
        return this.containsCrucialChanges;
    }

    public boolean containsVisualChanges() {
        return this.containsVisualChanges;
    }

    public AdditionalInfosTO getAdditionalInfos() {
        return this.additionalInfos;
    }

    public ChangeLevel getChangeLevel() {
        return this.changeLevel;
    }

    public String getClient() {
        return this.client;
    }

    @Deprecated
    @JsonIgnore
    public String getMandant() {
        return this.getClient();
    }

    public byte[] getSignatureContent() {
        return this.signatureContent;
    }

    public Date getSignatureDate() {
        return this.signatureDate;
    }

    public byte[] getSignatureDigest() {
        return this.signatureDigest;
    }

    public String getSignatureName() {
        return this.signatureName;
    }

    public Integer getSignaturePosition() {
        return this.signaturePosition;
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public SignatureType getType() {
        return this.type;
    }

    public boolean isCoveringWholeDocument() {
        return this.getChangeLevel() == ChangeLevel.UNCHANGED;
    }

    public void setAdditionalInfos(AdditionalInfosTO additionalInfos) {
        this.additionalInfos = additionalInfos;
    }

    public void setChangeLevel(ChangeLevel changeLevel) {
        this.changeLevel = changeLevel;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public void setContainsCrucialChanges(boolean containsCrucialChanges) {
        this.containsCrucialChanges = containsCrucialChanges;
    }

    public void setContainsVisualChanges(boolean containsVisualChanges) {
        this.containsVisualChanges = containsVisualChanges;
    }

    @Deprecated
    public void setMandant(String mandant) {
        this.setClient(mandant);
    }

    public void setSignatureContent(byte[] signatureContent) {
        if (null != signatureContent) {
            this.signatureContent = Arrays.copyOf(signatureContent, signatureContent.length);
        }
    }

    public void setSignatureDate(Date signatureDate) {
        this.signatureDate = signatureDate;
    }

    public void setSignatureDigest(byte[] signatureDigest) {
        if (null != signatureDigest) {
            this.signatureDigest = Arrays.copyOf(signatureDigest, signatureDigest.length);
        }
    }

    public void setSignatureName(String signatureName) {
        this.signatureName = signatureName;
    }

    public void setSignaturePosition(Integer signaturePosition) {
        this.signaturePosition = signaturePosition;
    }

    public void setType(SignatureType type) {
        this.type = type;
    }

    public String toString() {
        String sb = "SignatureTO name=" + this.signatureName + ", digest=" + (String)Optional.ofNullable(this.signatureDigest).map(d -> HexTools.bytesToHexString((byte[])d)).orElse(null) + ", date=" + this.signatureDate + ", client=" + this.client;
        return sb;
    }

    public static enum ChangeLevel {
        FORBIDDEN,
        PERMITTED_ANNOTATE,
        PERMITTED_FILL,
        PERMITTED_SIGN,
        PERMITTED_BASIC,
        IGNORABLE,
        UNCHANGED,
        UNDEFINED;

    }

    public static enum SignatureType {
        TIMESTAMP;

    }
}

