/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import java.io.IOException;

public class COSObjectStream
extends COSBasedObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_Type_ObjStm = COSName.constant("ObjStm");
    public static final COSName DK_First = COSName.constant("First");
    public static final COSName DK_N = COSName.constant("N");
    public static final COSName DK_Extends = COSName.constant("Extends");
    private COSStream stream;
    private long[][] objectTable;
    private IRandomAccess randomAccess;

    protected COSObjectStream(COSObject stream) {
        super(((COSStream)stream).getDict());
        this.stream = (COSStream)stream;
    }

    public int getFirst() {
        return this.getFieldInt(DK_First, -1);
    }

    public int getN() {
        return this.getFieldInt(DK_N, 0);
    }

    private long getOffsetByIndex(int index, COSDocumentParser parser) throws IOException {
        if (this.objectTable == null) {
            this.objectTable = new long[this.getN()][2];
            this.getRandomAccess().seek(0L);
            for (int i = 0; i < this.objectTable.length; ++i) {
                this.objectTable[i][0] = parser.readInt(this.getRandomAccess(), true);
                this.objectTable[i][1] = parser.readLong(this.getRandomAccess(), true);
            }
        }
        return this.objectTable[index][1];
    }

    protected IRandomAccess getRandomAccess() throws IOException {
        if (this.randomAccess == null) {
            this.randomAccess = new RandomAccessByteArray(this.stream.getDecodedBytes());
        }
        return this.randomAccess;
    }

    public COSObject loadObject(int index, COSDocumentParser parser) throws IOException, COSLoadException {
        if (index >= this.getN()) {
            return null;
        }
        long offset = this.getOffsetByIndex(index, parser);
        this.getRandomAccess().seek((long)this.getFirst() + offset);
        return (COSObject)parser.parseElement(this.getRandomAccess());
    }

    public void parse(int index, COSDocumentParser parser) throws IOException, COSLoadException {
        if (index >= this.getN()) {
            return;
        }
        long offset = this.getOffsetByIndex(index, parser);
        this.getRandomAccess().seek((long)this.getFirst() + offset);
        parser.parseElement(this.getRandomAccess());
    }

    public static class MetaClass
    extends COSBasedObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new COSObjectStream(object);
        }
    }
}

