/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDEmbeddedFile;
import de.intarsys.pdf.pd.PDFileSpecificationURL;
import de.intarsys.pdf.pd.PDObject;

public class PDFileSpecification
extends PDObject {
    public static final COSName CN_Type_Filespec = COSName.constant("Filespec");
    public static final COSName CN_Type_Alt_Filespec = COSName.constant("F");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_FS = COSName.constant("FS");
    public static final COSName DK_F = COSName.constant("F");
    public static final COSName DK_UF = COSName.constant("UF");
    public static final COSName CN_F_DOS = COSName.constant("DOS");
    public static final COSName CN_F_Mac = COSName.constant("Mac");
    public static final COSName CN_F_Unix = COSName.constant("Unix");
    public static final COSName CN_FS_URL = COSName.constant("URL");
    public static final COSName CN_Source = COSName.constant("Source");
    public static final COSName CN_Data = COSName.constant("Data");
    public static final COSName CN_Alternative = COSName.constant("Alternative");
    public static final COSName CN_Supplement = COSName.constant("Supplement");
    public static final COSName CN_Unspecified = COSName.constant("Unspecified");
    public static final COSName DK_EF = COSName.constant("EF");
    public static final COSName DK_RF = COSName.constant("RF");
    public static final COSName DK_Desc = COSName.constant("Desc");
    public static final COSName DK_AFRelationship = COSName.constant("AFRelationship");
    private COSName fileSystem = null;

    protected PDFileSpecification(COSObject object) {
        super(object);
    }

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_Filespec;
    }

    public COSName getAFRelationship() {
        COSName value = this.cosGetField(DK_AFRelationship).asName();
        if (value == null) {
            value = CN_Unspecified;
        }
        return value;
    }

    public String getDescription() {
        COSString cosDesc = this.cosGetField(DK_Desc).asString();
        if (cosDesc == null) {
            return null;
        }
        return cosDesc.stringValue();
    }

    public PDEmbeddedFile getEmbeddedFile(COSName flavor) {
        COSDictionary embeddedFileDict = this.getEmbeddedFiles();
        if (embeddedFileDict == null) {
            return null;
        }
        return (PDEmbeddedFile)PDEmbeddedFile.META.createFromCos(embeddedFileDict.get(flavor));
    }

    public COSDictionary getEmbeddedFiles() {
        return this.cosGetField(DK_EF).asDictionary();
    }

    public String getFile() {
        COSString cosFile = this.cosGetField(DK_F).asString();
        if (cosFile == null) {
            return null;
        }
        return cosFile.stringValue();
    }

    public String getFileSpecificationString(COSName flavor) {
        COSString string = this.cosGetField(flavor).asString();
        return string == null ? null : string.stringValue();
    }

    public COSName getFileSystem() {
        return this.fileSystem;
    }

    @Override
    protected void initializeFromCos() {
        super.initializeFromCos();
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.cosSetField(DK_FS, this.getFileSystem());
    }

    public void removeFlavor(COSName flavor) {
        this.cosRemoveField(flavor);
        COSDictionary embeddedFileDict = this.getEmbeddedFiles();
        if (embeddedFileDict != null) {
            embeddedFileDict.remove(flavor);
        }
    }

    public void setAFRelationship(COSName relationship) {
        this.cosSetField(DK_AFRelationship, relationship);
    }

    public void setDescription(String description) {
        this.setFieldString(DK_Desc, description);
    }

    public void setEmbeddedFile(COSName flavor, PDEmbeddedFile embeddedFile) {
        COSDictionary embeddedFileDict = this.getEmbeddedFiles();
        if (embeddedFileDict == null) {
            embeddedFileDict = COSDictionary.create();
            this.cosSetField(DK_EF, embeddedFileDict);
        }
        embeddedFileDict.put(flavor, embeddedFile.cosGetObject());
    }

    public void setFile(String file) {
        this.setFieldString(DK_F, file);
    }

    public void setFileSpecificationString(COSName flavor, String spec) {
        this.setFieldString(flavor, spec);
    }

    public void setFileSystem(COSName bs) {
        this.fileSystem = bs;
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class<?> instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDFileSpecification(object);
        }

        @Override
        protected COSBasedObject.MetaClass doDetermineClass(COSObject object) {
            COSName fileSystem = ((COSDictionary)object).get(DK_FS).asName();
            if (CN_FS_URL.equals(fileSystem)) {
                return PDFileSpecificationURL.META;
            }
            return META;
        }

        @Override
        public Class<PDFileSpecification> getRootClass() {
            return PDFileSpecification.class;
        }
    }
}

