/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDObject;

public class PDBorderStyle
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_W = COSName.constant("W");
    public static final COSName DK_S = COSName.constant("S");
    public static final COSName CN_S_S = COSName.constant("S");
    public static final COSName CN_S_D = COSName.constant("D");
    public static final COSName CN_S_B = COSName.constant("B");
    public static final COSName CN_S_I = COSName.constant("I");
    public static final COSName CN_S_U = COSName.constant("U");
    public static final COSName DK_D = COSName.constant("D");
    public static final COSName CN_Type_Border = COSName.constant("Border");

    protected PDBorderStyle(COSObject object) {
        super(object);
    }

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_Border;
    }

    public int[] getDashArray() {
        COSArray array = this.cosGetField(DK_D).asArray();
        if (array != null) {
            int[] result = new int[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                COSInteger value = array.get(i).asInteger();
                result[i] = value != null ? value.intValue() : 0;
            }
            return result;
        }
        return new int[]{3};
    }

    public COSName getStyle() {
        COSName style = this.cosGetField(DK_S).asName();
        if (style != null) {
            return style;
        }
        return CN_S_S;
    }

    public float getWidth() {
        return this.getFieldFixed(DK_W, 1.0f);
    }

    public void setDashArray(int[] newDashArray) {
        if (newDashArray == null || newDashArray.length == 1 && newDashArray[0] == 3) {
            this.cosRemoveField(DK_D);
            return;
        }
        COSArray a = COSArray.create(newDashArray.length);
        this.cosSetField(DK_D, a);
        for (int i = 0; i < newDashArray.length; ++i) {
            a.add(COSInteger.create(newDashArray[i]));
        }
    }

    public void setStyle(COSName newStyle) {
        this.cosSetField(DK_S, newStyle);
    }

    public void setWidth(float newWidth) {
        if (newWidth != 1.0f) {
            this.setFieldFixed(DK_W, newWidth);
        } else {
            this.cosRemoveField(DK_W);
        }
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDBorderStyle(object);
        }
    }
}

