/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PDAdditionalActions
extends PDObject {
    private static final String TYPE_FIELD = "Field";
    private static final String TYPE_DOC = "Doc";
    public static final COSName CN_trigger_E = COSName.constant("E");
    public static final COSName CN_trigger_X = COSName.constant("X");
    public static final COSName CN_trigger_D = COSName.constant("D");
    public static final COSName CN_trigger_U = COSName.constant("U");
    public static final COSName CN_trigger_Fo = COSName.constant("Fo");
    public static final COSName CN_trigger_Bl = COSName.constant("Bl");
    public static final COSName CN_trigger_PO = COSName.constant("PO");
    public static final COSName CN_trigger_PC = COSName.constant("PC");
    public static final COSName CN_trigger_PV = COSName.constant("PV");
    public static final COSName CN_trigger_PI = COSName.constant("PI");
    public static final COSName CN_trigger_O = COSName.constant("O");
    public static final COSName CN_trigger_K = COSName.constant("K");
    public static final COSName CN_trigger_F = COSName.constant("F");
    public static final COSName CN_trigger_V = COSName.constant("V");
    public static final COSName CN_trigger_C = COSName.constant("C");
    public static final COSName CN_trigger_DC = COSName.constant("DC");
    public static final COSName CN_trigger_WC = COSName.constant("WC");
    public static final COSName CN_trigger_WS = COSName.constant("WS");
    public static final COSName CN_trigger_DS = COSName.constant("DS");
    public static final COSName CN_trigger_WP = COSName.constant("WP");
    public static final COSName CN_trigger_DP = COSName.constant("DP");
    private static Map reasonToName = new HashMap();
    private static Map reasonToType = new HashMap();
    public static final COSName CN_T_Mouse_Down = CN_trigger_D;
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());

    public static String getEventName(COSName reason) {
        String result = (String)reasonToName.get(reason);
        if (result == null) {
            return "";
        }
        return result;
    }

    public static String getEventType(COSName reason) {
        String result = (String)reasonToType.get(reason);
        if (result == null) {
            return "";
        }
        return result;
    }

    protected PDAdditionalActions(COSObject object) {
        super(object);
    }

    public void addAction(COSName trigger, PDAction action) {
        if (trigger != null && action != null) {
            PDAction a = this.getAction(trigger);
            if (a == null) {
                this.cosSetField(trigger, action.cosGetDict());
            } else {
                a.addNext(action);
            }
        }
    }

    public void clearAction(COSName trigger) {
        if (trigger != null) {
            this.cosRemoveField(trigger);
        }
    }

    protected void collectActions(PDAction current, List<PDAction> actions) {
        if (current == null) {
            return;
        }
        actions.add(current);
        List next = current.getNext();
        if (next != null) {
            for (PDAction nextAction : next) {
                this.collectActions(nextAction, actions);
            }
        }
    }

    public PDAction getAction(COSName trigger) {
        COSObject cosObject = this.cosGetField(trigger);
        if (cosObject.isNull()) {
            return null;
        }
        return (PDAction)PDAction.META.createFromCos(cosObject);
    }

    public List<PDAction> getActions() {
        ArrayList<PDAction> actions = new ArrayList<PDAction>();
        Iterator i = this.cosGetDict().keySet().iterator();
        while (i.hasNext()) {
            COSName trigger = ((COSObject)i.next()).asName();
            PDAction action = this.getAction(trigger);
            this.collectActions(action, actions);
        }
        return actions;
    }

    public void setAction(COSName trigger, PDAction action) {
        if (trigger == null) {
            return;
        }
        this.setFieldObject(trigger, action);
    }

    static {
        reasonToName.put(CN_trigger_K, "Keystroke");
        reasonToName.put(CN_trigger_V, "Validate");
        reasonToName.put(CN_trigger_Fo, "Focus");
        reasonToName.put(CN_trigger_Bl, "Blur");
        reasonToName.put(CN_trigger_F, "Format");
        reasonToName.put(CN_trigger_C, "Calculate");
        reasonToName.put(CN_trigger_U, "Mouse Up");
        reasonToName.put(CN_trigger_D, "Mouse Down");
        reasonToName.put(CN_trigger_E, "Mouse Enter");
        reasonToName.put(CN_trigger_X, "Mouse Exit");
        reasonToName.put(CN_trigger_WP, "WillPrint");
        reasonToName.put(CN_trigger_DP, "DidPrint");
        reasonToName.put(CN_trigger_WS, "WillSave");
        reasonToName.put(CN_trigger_DS, "DidSave");
        reasonToType.put(CN_trigger_K, TYPE_FIELD);
        reasonToType.put(CN_trigger_V, TYPE_FIELD);
        reasonToType.put(CN_trigger_Fo, TYPE_FIELD);
        reasonToType.put(CN_trigger_Bl, TYPE_FIELD);
        reasonToType.put(CN_trigger_F, TYPE_FIELD);
        reasonToType.put(CN_trigger_C, TYPE_FIELD);
        reasonToType.put(CN_trigger_U, TYPE_FIELD);
        reasonToType.put(CN_trigger_D, TYPE_FIELD);
        reasonToType.put(CN_trigger_E, TYPE_FIELD);
        reasonToType.put(CN_trigger_X, TYPE_FIELD);
        reasonToType.put(CN_trigger_WP, TYPE_DOC);
        reasonToType.put(CN_trigger_DP, TYPE_DOC);
        reasonToType.put(CN_trigger_WS, TYPE_DOC);
        reasonToType.put(CN_trigger_DS, TYPE_DOC);
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDAdditionalActions(object);
        }
    }
}

