/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.DefaultAppearance;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PDAcroFormNode
extends PDObject {
    public static final COSName DK_Encoding = COSName.constant("Encoding");
    public static final COSName DK_DR = COSName.constant("DR");
    public static final COSName DK_Font = COSName.constant("Font");
    public static final COSName DK_DA = COSName.constant("DA");
    public static final COSName DK_Q = COSName.constant("Q");
    private CSContent defaultAppearanceContent;
    private DefaultAppearance defaultAppearance;

    public static String canonicalize(String name) {
        return name.toLowerCase();
    }

    protected PDAcroFormNode(COSObject object) {
        super(object);
    }

    public abstract void addField(PDAcroFormField var1);

    protected PDAcroFormField basicGetField(String name, boolean canonical) {
        List children = this.getGenericChildren();
        if (children == null || name == null) {
            return null;
        }
        String childName = null;
        String childPath = null;
        int separatorIndex = name.indexOf(46);
        if (separatorIndex < 0) {
            childName = name;
        } else {
            childName = name.substring(0, separatorIndex);
            childPath = name.substring(separatorIndex + 1);
        }
        for (PDAcroFormField field : children) {
            PDAcroFormField child;
            String fieldName = field.getLocalName(canonical);
            if (childName.equals(fieldName)) {
                if (childPath == null) {
                    return field;
                }
                return field.basicGetField(childPath, canonical);
            }
            if (fieldName != null || (child = field.basicGetField(name, canonical)) == null) continue;
            return child;
        }
        return null;
    }

    public List collectLeafFields() {
        return this.collectLeafFields(new ArrayList());
    }

    protected List collectLeafFields(List result) {
        List children = this.getGenericChildren();
        if (children == null) {
            return Collections.emptyList();
        }
        for (PDAcroFormField child : children) {
            child.collectLeafFields(result);
        }
        return result;
    }

    public abstract PDAcroForm getAcroForm();

    public PDAnnotation getAnnotation(int index) {
        return (PDAnnotation)this.getAnnotations().get(index);
    }

    public List getAnnotations() {
        return this.getAnnotations(new ArrayList());
    }

    protected List getAnnotations(List annotations) {
        for (PDAcroFormNode kid : this.getGenericChildren()) {
            kid.getAnnotations(annotations);
        }
        return annotations;
    }

    protected DefaultAppearance getDefaultAppearance() {
        if (this.defaultAppearance == null) {
            this.defaultAppearance = new DefaultAppearance(this);
        }
        return this.defaultAppearance;
    }

    public CSContent getDefaultAppearanceContent() {
        COSString cosObject;
        if (this.defaultAppearanceContent == null && (cosObject = this.cosGetFieldInheritable(DK_DA).asString()) != null) {
            this.defaultAppearanceContent = CSContent.createFromBytes(cosObject.byteValue());
        }
        return this.defaultAppearanceContent;
    }

    public PDFont getDefaultAppearanceFont() {
        PDFont result = this.getDefaultAppearance().getFont();
        if (result == null) {
            if (this.getAcroForm() != this) {
                result = this.getAcroForm().getDefaultAppearanceFont();
            }
            if (result == null) {
                result = PDFontTools.createBuiltinFont("Helvetica");
            }
        }
        return result;
    }

    public float[] getDefaultAppearanceFontColor() {
        return this.getDefaultAppearance().getFontColorValues();
    }

    public COSName getDefaultAppearanceFontName() {
        return this.getDefaultAppearance().getFontName();
    }

    public float getDefaultAppearanceFontSize() {
        return this.getDefaultAppearance().getFontSize();
    }

    public PDAcroFormField getField(String path) {
        return this.getField(path, false);
    }

    public PDAcroFormField getField(String name, boolean canonicalName) {
        String basicname = canonicalName ? PDAcroFormNode.canonicalize(name) : name;
        return this.basicGetField(basicname, canonicalName);
    }

    public int getQuadding() {
        COSInteger cosObject = this.cosGetFieldInheritable(DK_Q).asInteger();
        if (cosObject == null) {
            return 0;
        }
        return cosObject.intValue();
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.defaultAppearanceContent = null;
        this.defaultAppearance = null;
    }

    public abstract boolean removeField(PDAcroFormField var1);

    protected void setDefaultAppearance(DefaultAppearance defaultAppearanceParser) {
        this.defaultAppearance = defaultAppearanceParser;
    }

    public void setDefaultAppearanceContent(CSContent pContent) {
        if (pContent != null) {
            this.cosSetField(DK_DA, COSString.create(pContent.toByteArray()));
        } else {
            this.cosRemoveField(DK_DA);
        }
    }

    public void setDefaultAppearanceFont(PDFont font) {
        this.getDefaultAppearance().setFont(font);
    }

    public void setDefaultAppearanceFontColor(float[] color) {
        this.getDefaultAppearance().setFontColorValues(color);
    }

    public void setDefaultAppearanceFontSize(float size) {
        this.getDefaultAppearance().setFontSize(size);
    }

    public void setQuadding(int quadding) {
        this.cosSetFieldInheritable(DK_Q, COSInteger.create(quadding));
    }

    public static abstract class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        public Class getRootClass() {
            return PDAcroFormNode.class;
        }
    }
}

