/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.crypt.ArcFourCryptHandler;
import de.intarsys.pdf.crypt.COSEncryption;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ICryptHandler;
import de.intarsys.pdf.crypt.SystemSecurityHandler;

public class SystemSecurityHandlerV2
extends SystemSecurityHandler {
    private ICryptHandler cryptHandler;

    protected SystemSecurityHandlerV2(COSDictionary dict) {
        super(dict);
    }

    protected ICryptHandler createCryptHandler() throws COSSecurityException {
        ArcFourCryptHandler result = new ArcFourCryptHandler();
        result.initialize(this.getSecurityHandler().getCryptKey());
        return result;
    }

    protected byte[] decrypt(COSObjectKey objectKey, byte[] bytes) throws COSSecurityException {
        return this.getCryptHandler().decrypt(objectKey, bytes);
    }

    @Override
    public byte[] decryptFile(COSObjectKey key, COSDictionary dict, byte[] bytes) throws COSSecurityException {
        return this.decrypt(key, bytes);
    }

    @Override
    public byte[] decryptStream(COSObjectKey key, COSDictionary dict, byte[] bytes) throws COSSecurityException {
        return this.decrypt(key, bytes);
    }

    @Override
    public byte[] decryptString(COSObjectKey key, byte[] bytes) throws COSSecurityException {
        return this.decrypt(key, bytes);
    }

    protected byte[] encrypt(COSObjectKey objectKey, byte[] bytes) throws COSSecurityException {
        if (!this.isEnabled()) {
            return bytes;
        }
        return this.getCryptHandler().encrypt(objectKey, bytes);
    }

    @Override
    public byte[] encryptFile(COSObjectKey key, COSDictionary dict, byte[] bytes) throws COSSecurityException {
        return this.encrypt(key, bytes);
    }

    @Override
    public byte[] encryptStream(COSObjectKey key, COSDictionary dict, byte[] bytes) throws COSSecurityException {
        return this.encrypt(key, bytes);
    }

    @Override
    public byte[] encryptString(COSObjectKey key, byte[] bytes) throws COSSecurityException {
        return this.encrypt(key, bytes);
    }

    protected ICryptHandler getCryptHandler() throws COSSecurityException {
        if (this.cryptHandler == null) {
            this.cryptHandler = this.createCryptHandler();
        }
        return this.cryptHandler;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        COSEncryption encryption = this.getEncryption();
        encryption.setFieldInt(COSEncryption.DK_Length, 128);
    }
}

