/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSCompositeObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.attribute.TaggedAttribute;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class COSBasedObject
implements IAttributeSupport,
ICOSObjectListener {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private final COSObject object;
    private final IAttributeSupport attributeSupport;

    protected COSBasedObject(COSObject object) {
        this.object = object;
        if (object != null) {
            object.addObjectListener(this);
        }
        this.attributeSupport = object instanceof IAttributeSupport ? (IAttributeSupport)object : new AttributeMap();
    }

    @Override
    public void changed(COSObject pObject, Object slot, Object oldValue, Object newValue) {
        if (slot != COSObject.SLOT_CONTAINER) {
            this.invalidateCaches();
        }
    }

    public COSArray cosGetArray() {
        return (COSArray)this.object;
    }

    public COSDictionary cosGetDict() {
        return (COSDictionary)this.object;
    }

    public COSDocument cosGetDoc() {
        return this.object.getDoc();
    }

    public COSObject cosGetField(COSName name) {
        return this.cosGetDict().get(name);
    }

    public COSObject cosGetObject() {
        return this.object;
    }

    public COSStream cosGetStream() {
        return (COSStream)this.object;
    }

    public boolean cosHasField(COSName name) {
        return !this.cosGetDict().get(name).isNull();
    }

    public COSObject cosRemoveField(COSName name) {
        return this.cosGetDict().remove(name);
    }

    public COSObject cosSetField(COSName name, COSObject cosObj) {
        if (cosObj == null || cosObj.isNull()) {
            return this.cosRemoveField(name);
        }
        return this.cosGetDict().put(name, cosObj);
    }

    public Object getAttribute(Object key) {
        return this.attributeSupport.getAttribute((Object)new TaggedAttribute(key, this.getClass()));
    }

    public boolean getFieldBoolean(COSName name, boolean defaultValue) {
        COSBoolean value = this.cosGetField(name).asBoolean();
        if (value == null) {
            return defaultValue;
        }
        return value.booleanValue();
    }

    public CDSDate getFieldDate(COSName name, CDSDate defaultValue) {
        COSString value = this.cosGetField(name).asString();
        if (value == null) {
            return defaultValue;
        }
        return CDSDate.createFromCOS(value);
    }

    public float getFieldFixed(COSName name, float defaultValue) {
        COSNumber value = this.cosGetField(name).asNumber();
        if (value == null) {
            return defaultValue;
        }
        return value.floatValue();
    }

    public float[] getFieldFixedArray(COSName name, float[] defaultValue) {
        COSArray array = this.cosGetField(name).asArray();
        if (array != null) {
            float[] result = new float[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                COSNumber fixed = array.get(i).asNumber();
                result[i] = fixed != null ? fixed.floatValue() : 0.0f;
            }
            return result;
        }
        return defaultValue;
    }

    public int getFieldInt(COSName name, int defaultValue) {
        COSNumber value = this.cosGetField(name).asNumber();
        if (value == null) {
            return defaultValue;
        }
        return value.intValue();
    }

    public String getFieldMLString(COSName name, String defaultValue) {
        COSObject value = this.cosGetField(name);
        if (value.isNull()) {
            return defaultValue;
        }
        COSString string = value.asString();
        if (string != null) {
            return string.multiLineStringValue();
        }
        return value.stringValue();
    }

    public String getFieldString(COSName name, String defaultValue) {
        COSObject value = this.cosGetField(name);
        if (value.isNull()) {
            return defaultValue;
        }
        return value.stringValue();
    }

    protected void initializeFromCos() {
    }

    protected void initializeFromScratch() {
    }

    public void invalidateCaches() {
    }

    public Object removeAttribute(Object key) {
        return this.attributeSupport.removeAttribute((Object)new TaggedAttribute(key, this.getClass()));
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributeSupport.setAttribute((Object)new TaggedAttribute(key, this.getClass()), value);
    }

    public COSObject setFieldBoolean(COSName name, boolean value) {
        COSBoolean cosValue = COSBoolean.create(value);
        return this.cosSetField(name, cosValue);
    }

    public COSObject setFieldFixed(COSName name, float value) {
        COSFixed cosValue = COSFixed.create(value);
        return this.cosSetField(name, cosValue);
    }

    protected COSObject setFieldFixedArray(COSName key, float[] array) {
        if (array == null || array.length == 0) {
            return this.cosRemoveField(key);
        }
        COSArray cosArray = COSArray.create();
        for (int i = 0; i < array.length; ++i) {
            cosArray.add(COSFixed.create(array[i]));
        }
        return this.cosSetField(key, cosArray);
    }

    public COSObject setFieldInt(COSName name, int value) {
        COSInteger cosValue = COSInteger.create(value);
        return this.cosSetField(name, cosValue);
    }

    public COSObject setFieldMLString(COSName name, String value) {
        if (value == null) {
            return this.cosRemoveField(name);
        }
        COSString cosValue = COSString.createMultiLine(value);
        return this.cosSetField(name, cosValue);
    }

    public COSObject setFieldName(COSName name, String value) {
        if (value == null) {
            return this.cosRemoveField(name);
        }
        COSName cosValue = COSName.create(value.getBytes());
        return this.cosSetField(name, cosValue);
    }

    public COSObject setFieldObject(COSName name, COSBasedObject value) {
        if (value == null) {
            return this.cosRemoveField(name);
        }
        return this.cosSetField(name, value.cosGetObject());
    }

    public COSObject setFieldString(COSName name, String value) {
        if (value == null) {
            return this.cosRemoveField(name);
        }
        COSString cosValue = COSString.create(value);
        return this.cosSetField(name, cosValue);
    }

    public String toString() {
        return this.cosGetObject().toString();
    }

    public static class MetaClass
    extends de.intarsys.pdf.cos.MetaClass {
        private Constructor constructor;

        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        public COSBasedObject createFromCos(COSObject object) {
            COSBasedObject result = null;
            if (object != null && !object.isNull()) {
                MetaClass metaClass;
                if (object instanceof COSCompositeObject) {
                    result = (COSBasedObject)((COSCompositeObject)object).getAttribute(this.getRootClass());
                }
                if (result == null && (metaClass = this.doDetermineClass(object)) != null && (result = metaClass.doCreateCOSBasedObject(object)) != null) {
                    result.initializeFromCos();
                    if (object instanceof COSCompositeObject) {
                        ((COSCompositeObject)object).setAttribute(this.getRootClass(), result);
                    }
                }
            }
            return result;
        }

        public COSBasedObject createNew() {
            COSObject cosObject = this.doCreateCOSObject();
            if (this.isIndirect()) {
                cosObject.beIndirect();
            }
            COSBasedObject result = this.doCreateCOSBasedObject(cosObject);
            result.initializeFromScratch();
            if (cosObject instanceof COSCompositeObject) {
                ((COSCompositeObject)cosObject).setAttribute(this.getRootClass(), result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            try {
                MetaClass metaClass = this;
                synchronized (metaClass) {
                    if (this.constructor == null) {
                        this.constructor = this.getInstanceClass().getDeclaredConstructor(COSObject.class);
                        this.constructor.setAccessible(true);
                    }
                }
                COSBasedObject result = (COSBasedObject)this.constructor.newInstance(object);
                return result;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Constructor " + this.getInstanceClass().getName() + "(COSObject) missing", e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(this.getInstanceClass().getName() + " can not be instantiated (" + e.getMessage() + ")", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(this.getInstanceClass().getName() + " illegal access (" + e.getMessage() + ")", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(this.getInstanceClass().getName() + " invocation target exception(" + e.getMessage() + ")", e.getCause());
            }
        }

        protected COSObject doCreateCOSObject() {
            return COSDictionary.create();
        }

        protected MetaClass doDetermineClass(COSObject object) {
            return this;
        }

        protected boolean isIndirect() {
            return true;
        }
    }
}

