/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cds;

import de.intarsys.pdf.cds.CDSBase;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.tools.date.DateEnvironment;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CDSDate
extends CDSBase {
    private static final String DATE_FORMAT = "'D':yyyyMMddHHmmssXXX";
    private static final Pattern DATE_FORMAT_FIX_PATTERN = Pattern.compile("(?<relation>[+-])(?<hours>\\d{2}):(?<minutes>\\d{2})$");
    private static final String DATE_FORMAT_FIX_REPLACEMENT = "${relation}${hours}'${minutes}'";
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final DateFormat DISPLAY_DATE_FORMAT = DateFormat.getDateTimeInstance(2, 2);
    private static final Pattern DATE_PATTERN = Pattern.compile("(?:D:)?(?<year>\\d{4})(?:(?<month>\\d{2})    (?:(?<day>\\d{2})        (?:(?<hour>\\d{2})            (?:(?<minute>\\d{2})                (?:(?<second>\\d{2}))?            )?        )?    )?)?(?:(?<tzRelation>[Z+-])    (?<tzHours>\\d{2})?'?    (?:(?<tzMinutes>\\d{2})'?)?)?", 4);

    public static CDSDate createFrom(Instant instant) {
        if (instant == null) {
            return null;
        }
        return CDSDate.createFromCOS(COSString.create(CDSDate.toString(instant)));
    }

    public static CDSDate createFrom(Instant instant, ZoneId zone) {
        if (instant == null) {
            return null;
        }
        return CDSDate.createFromCOS(COSString.create(CDSDate.toString(instant, zone)));
    }

    public static CDSDate createFrom(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return CDSDate.createFromCOS(COSString.create((String)value));
        }
        if (value instanceof Instant) {
            return CDSDate.createFrom((Instant)value);
        }
        if (value instanceof COSString) {
            return CDSDate.createFromCOS((COSString)value);
        }
        if (value instanceof Number) {
            return CDSDate.createFrom(Instant.ofEpochMilli(((Number)value).longValue()));
        }
        if (value instanceof Date) {
            return CDSDate.createFrom(CDSDate.toString((Date)value));
        }
        throw new IllegalArgumentException("cannot convert " + value + " to CDSDate");
    }

    public static CDSDate createFromCOS(COSString string) {
        if (string == null) {
            return null;
        }
        return new CDSDate(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(CDSDate cdsDate) {
        DateFormat dateFormat = DISPLAY_DATE_FORMAT;
        synchronized (dateFormat) {
            return CDSDate.format(DISPLAY_DATE_FORMAT, cdsDate);
        }
    }

    public static String format(Format format, CDSDate cdsDate) {
        String strDate = "";
        if (cdsDate != null) {
            try {
                strDate = format.format(cdsDate.toDate());
            }
            catch (ParseException e) {
                strDate = cdsDate.toString();
            }
        }
        return strDate;
    }

    private static int getInteger(Matcher matcher, String key, int defaultValue) {
        String value = matcher.group(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static Calendar toCalendar(String string) throws ParseException {
        Matcher matcher = DATE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new ParseException("can't parse date string: " + string, 0);
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, CDSDate.getInteger(matcher, "year", 0));
        calendar.set(2, CDSDate.getInteger(matcher, "month", 1) - 1);
        calendar.set(5, CDSDate.getInteger(matcher, "day", 1));
        calendar.set(11, CDSDate.getInteger(matcher, "hour", 0));
        calendar.set(12, CDSDate.getInteger(matcher, "minute", 0));
        calendar.set(13, CDSDate.getInteger(matcher, "second", 0));
        calendar.set(14, 0);
        String tzRelation = matcher.group("tzRelation");
        if (tzRelation != null) {
            SimpleTimeZone timeZone;
            if ("Z".equals(tzRelation)) {
                timeZone = new SimpleTimeZone(0, "Z");
            } else {
                int offsetHours = CDSDate.getInteger(matcher, "tzHours", 0);
                int offsetMinutes = CDSDate.getInteger(matcher, "tzMinutes", 0);
                int offset = offsetHours * 3600000 + offsetMinutes * 60000;
                if ("-".equals(tzRelation)) {
                    offset = -offset;
                }
                timeZone = new SimpleTimeZone(offset, "temp");
            }
            ((Calendar)calendar).setTimeZone(timeZone);
        }
        return calendar;
    }

    public static Date toDate(String string) throws ParseException {
        return CDSDate.toCalendar(string).getTime();
    }

    @Deprecated
    public static Date toDateWithZone(String string) throws ParseException {
        return CDSDate.toDate(string);
    }

    public static String toString(Calendar calendar) {
        return CDSDate.toString(calendar.getTime(), calendar.getTimeZone());
    }

    public static String toString(Date date) {
        return CDSDate.toString(date, TimeZone.getDefault());
    }

    public static String toString(Date date, TimeZone timeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(timeZone);
        String string = dateFormat.format(date);
        Matcher matcher = DATE_FORMAT_FIX_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.replaceFirst(DATE_FORMAT_FIX_REPLACEMENT);
        }
        return string;
    }

    public static String toString(Instant instant) {
        return CDSDate.toString(instant, ZoneId.systemDefault());
    }

    public static String toString(Instant instant, ZoneId zone) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT).withZone(zone);
        String string = formatter.format(instant);
        Matcher matcher = DATE_FORMAT_FIX_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.replaceFirst(DATE_FORMAT_FIX_REPLACEMENT);
        }
        return string;
    }

    @Deprecated
    public static String toStringWithZone(Date date) {
        return CDSDate.toString(date, TimeZone.getDefault());
    }

    @Deprecated
    public static String toStringWithZone(Date date, TimeZone timeZone) {
        return CDSDate.toString(date, timeZone);
    }

    public CDSDate() {
        super(COSString.create(CDSDate.toString(DateEnvironment.get().now())));
    }

    protected CDSDate(COSString newDateString) {
        super(newDateString);
    }

    public String stringValue() {
        return ((COSString)this.cosGetObject()).stringValue();
    }

    public Date toDate() throws ParseException {
        return CDSDate.toDate(this.stringValue());
    }

    public String toFormattedString() {
        return CDSDate.format(this);
    }
}

