/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.annotation;

import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.app.annotation.IAnnotationOutlet;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.tools.provider.ProviderTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StandardAnnotationOutlet
implements IAnnotationOutlet {
    private Map<COSName, IAnnotationFactory> instances = new HashMap<COSName, IAnnotationFactory>();
    private boolean initialized = false;
    private boolean lookupProviders = true;

    protected IAnnotationFactory[] findProviders() {
        ArrayList<IAnnotationFactory> result = new ArrayList<IAnnotationFactory>();
        Iterator ps = ProviderTools.providers(IAnnotationFactory.class);
        while (ps.hasNext()) {
            result.add((IAnnotationFactory)ps.next());
        }
        return result.toArray(new IAnnotationFactory[result.size()]);
    }

    @Override
    public synchronized IAnnotationFactory[] getAnnotationFactories() {
        this.init();
        return this.instances.values().toArray(new IAnnotationFactory[this.instances.size()]);
    }

    protected void init() {
        if (!this.lookupProviders || this.initialized) {
            return;
        }
        this.initialized = true;
        IAnnotationFactory[] providers = this.findProviders();
        for (int i = 0; i < providers.length; ++i) {
            IAnnotationFactory provider = providers[i];
            this.registerAnnotationFactory(provider);
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    @Override
    public synchronized IAnnotationFactory lookupAnnotationFactory(COSName type) {
        this.init();
        return this.instances.get(type);
    }

    @Override
    public synchronized void registerAnnotationFactory(IAnnotationFactory factory) {
        this.instances.put(factory.getAnnotationType(), factory);
    }

    public void setLookupProviders(boolean lookupProviders) {
        this.lookupProviders = lookupProviders;
    }

    @Override
    public synchronized void unregisterAnnotationFactory(IAnnotationFactory factory) {
        this.instances.remove(factory.getAnnotationType());
    }
}

