/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ssl;

import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.security.KeyStoreTools;
import de.intarsys.tools.ssl.IConfigurableTrustManagerProvider;
import de.intarsys.tools.ssl.ITrustManagerProvider;
import de.intarsys.tools.ssl.TrustAllManager;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableTrustManagerProvider
implements IConfigurableTrustManagerProvider {
    private static final Logger Log = LoggerFactory.getLogger(ConfigurableTrustManagerProvider.class);
    private KeyStore trustStore;
    private Secret trustStorePassword;
    private String provider;
    private boolean trustAll = false;
    private String trustStoreType;
    private ILocator trustStoreLocator;

    public static ITrustManagerProvider createGullible() {
        ConfigurableTrustManagerProvider result = new ConfigurableTrustManagerProvider();
        result.setTrustAll(true);
        return result;
    }

    public ConfigurableTrustManagerProvider() {
    }

    protected ConfigurableTrustManagerProvider(ConfigurableTrustManagerProvider other) {
        this.provider = other.provider;
        this.trustAll = other.trustAll;
        this.trustStore = other.trustStore;
        this.trustStoreLocator = other.trustStoreLocator;
        this.trustStorePassword = other.trustStorePassword;
        this.trustStoreType = other.trustStoreType;
    }

    @Override
    public TrustManager[] createTrustManagers() throws GeneralSecurityException, IOException {
        if (this.isTrustAll()) {
            Log.warn("{} SSLContext will trust all certificates", (Object)this);
            return new TrustManager[]{new TrustAllManager()};
        }
        KeyStore tmpTrustStore = this.getOrCreateTrustStore();
        TrustManager[] managers = null;
        if (tmpTrustStore == null) {
            Log.debug("{} SSLContext will use default trust root", (Object)this);
        } else {
            Log.debug("{} SSLContext will use default explicit store from {}", (Object)this, (Object)this.getTrustStoreLocator());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(tmpTrustStore);
            managers = trustManagerFactory.getTrustManagers();
        }
        return managers;
    }

    protected KeyStore getOrCreateTrustStore() throws IOException, GeneralSecurityException {
        if (this.getTrustStore() == null) {
            return KeyStoreTools.createJavaKeyStore((ILocator)this.getTrustStoreLocator(), (String)(this.getTrustStoreType() == null ? KeyStore.getDefaultType() : this.getTrustStoreType()), (char[])CryptoTools.getChars((Secret)this.getTrustStorePassword()));
        }
        return this.getTrustStore();
    }

    public String getProvider() {
        return this.provider;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public ILocator getTrustStoreLocator() {
        return this.trustStoreLocator;
    }

    public Secret getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    @Override
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Override
    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    @Override
    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    @Override
    public void setTrustStoreLocator(ILocator trustStoreLocator) {
        this.trustStoreLocator = trustStoreLocator;
    }

    @Override
    public void setTrustStorePassword(Secret trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @Override
    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }
}

