/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.validation;

import de.intarsys.asn1.cms.SignedAttributes;
import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.security.algorithm.common.Algorithm;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.validation.BasicSignatureEntryValidator;
import de.intarsys.security.app.validation.ISignatureEntryValidator;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.SignatureEntryValidatorFactory;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.method.cms.signature.CMSSignature;
import de.intarsys.security.method.pdf.signature.Pkcs7Sha1SignatureEntry;
import de.intarsys.security.method.pdf.validation.PACKAGE;
import de.intarsys.security.signature.EncodedSignature;
import de.intarsys.security.signature.EncodedSignatureEntry;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSDigest;
import de.intarsys.security.standard.validation.VSMathematicalSignature;
import de.intarsys.security.standard.validation.VSSignature;
import de.intarsys.security.standard.validation.VSSignatureEntry;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSMathematicalSignature;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;

public class Pkcs7Sha1SignatureEntryValidator
extends BasicSignatureEntryValidator {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected void basicValidateDataDigest(CMSSignature signature, IDigest dataDigest, IVSSignature state) throws IOException {
        byte[] sha1Content = signature.getSignedContent();
        if (!Arrays.equals(sha1Content, dataDigest.getBytes())) {
            IValidationMessage msg = CommonValidationMessages.ERROR_DIGEST_VERIFIED_FALSE();
            VSDigest digestState = VSDigest.createInvalid((IValidationMessage)msg);
            ((VSSignature)state).addDigestState((IVSDigest)digestState);
        }
    }

    protected IVSSignature basicValidateSignedAttributes(CMSSignature signature, int signerInfoId, IDigest dataDigest) throws IOException {
        IDigester digester;
        IDigest signedDigest = null;
        VSDigest digestState = new VSDigest();
        if (dataDigest != null) {
            digestState.setCalculatedDigest(dataDigest.getBytes());
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)dataDigest.getAlgorithmName());
            AlgorithmSpec digestAlgorithmSpec = new AlgorithmSpec((Algorithm)digestAlgorithm);
            digestState.setAlgorithmSpec(digestAlgorithmSpec);
        }
        SignerInfo signerInfo = signature.getSignerInfo(signerInfoId);
        try {
            digester = signature.getDigester(signerInfoId);
        }
        catch (NoSuchAlgorithmException e) {
            IValidationMessage msg = CommonValidationMessages.ERROR_ALGORITHM_UNKNOWN((Exception)e, (String)signature.getHashAlgorithmOID(signerInfoId));
            VSSignature state = new VSSignature(dataDigest);
            state.setSignatureState(VSMathematicalSignature.createInvalid((IValidationMessage)msg));
            state.addDigestState((IVSDigest)VSDigest.createInvalid((IValidationMessage)msg));
            return state;
        }
        SignedAttributes signedAttrs = signerInfo.getSignedAttrs();
        IDigest messageDigest = signature.getMessageDigest(signerInfo);
        if (messageDigest == null) {
            IValidationMessage msg = ValidationMessage.createError((String)Msg.getString("CMSSignatureEntryValidator.SignedAttributeMessageDigestMissing", new Object[0]));
            digestState.invalidate(msg);
        } else {
            digestState.setReferenceDigest(messageDigest.getBytes());
            if (digestState.getAlgorithmSpec() == null) {
                DigestAlgorithm digestAlgorithm = DigestAlgorithm.lookupAlgorithm((String)messageDigest.getAlgorithmName());
                AlgorithmSpec digestAlgorithmSpec = new AlgorithmSpec((Algorithm)digestAlgorithm);
                digestState.setAlgorithmSpec(digestAlgorithmSpec);
            }
            if (dataDigest != null) {
                if (messageDigest.equals(dataDigest)) {
                    digestState.increaseState(0);
                } else {
                    digestState.increaseState(3);
                    digestState.addMessage(CommonValidationMessages.ERROR_DIGEST_VERIFIED_FALSE());
                }
            }
        }
        byte[] derEncoded = signedAttrs.derSetEncoded();
        signedDigest = digester.digest(derEncoded);
        IVSSignature pkcs1State = this.validateDirect(signature, signerInfoId, signedDigest);
        if (digestState.getReferenceDigest() == null && pkcs1State.getDigestStates().size() != 0) {
            byte[] pkcs1SignedDigest = ((IVSDigest)pkcs1State.getDigestStates().get(0)).getReferenceDigest();
            digestState.setReferenceDigest(pkcs1SignedDigest);
        }
        VSSignature state = new VSSignature(dataDigest);
        state.setSignatureState(pkcs1State.getSignatureState());
        state.addDigestState((IVSDigest)digestState);
        if (digestState.isUndefined()) {
            state.increaseState(2);
        }
        return state;
    }

    public IVSSignatureEntry validate(ISignatureEntry signatureEntry, IDigest digest, IValidationParameters parameters) {
        Pkcs7Sha1SignatureEntry mySignatureEntry = (Pkcs7Sha1SignatureEntry)signatureEntry;
        CMSSignature signature = mySignatureEntry.getCmsSignature();
        VSSignature signatureState = null;
        int signerInfoId = mySignatureEntry.getSignerInfoId();
        SignerInfo signerInfo = signature.getSignerInfo(signerInfoId);
        SignedAttributes signedAttrs = signerInfo.getSignedAttrs();
        try {
            signatureState = signedAttrs == null ? this.validateDirect(signature, signerInfoId, digest) : this.validateSignedAttributes(signature, signerInfoId, digest);
        }
        catch (IOException e) {
            signatureState = new VSSignature(digest);
            signatureState.invalidate(CommonValidationMessages.ERROR_IO((Exception)e));
        }
        VSSignatureEntry entryState = new VSSignatureEntry((ISignatureEntry)mySignatureEntry);
        entryState.setSignatureState((IVSSignature)signatureState);
        return entryState;
    }

    protected IVSSignature validateDirect(CMSSignature signature, int signerInfoId, IDigest dataDigest) throws IOException {
        IDigester digester;
        try {
            digester = signature.getDigester(signerInfoId);
        }
        catch (NoSuchAlgorithmException e) {
            IValidationMessage msg = CommonValidationMessages.ERROR_ALGORITHM_UNKNOWN((Exception)e, (String)signature.getHashAlgorithmOID(signerInfoId));
            VSSignature state = new VSSignature(dataDigest);
            state.setSignatureState(VSMathematicalSignature.createInvalid((IValidationMessage)msg));
            state.addDigestState((IVSDigest)VSDigest.createInvalid((IValidationMessage)msg));
            return state;
        }
        IDigest signedDigest = digester.digest(signature.getSignedContent());
        IVSSignature state = this.validatePkcs1(signature, signerInfoId, signedDigest);
        this.basicValidateDataDigest(signature, dataDigest, state);
        return state;
    }

    protected IVSSignature validatePkcs1(CMSSignature signature, int signerInfoId, IDigest signedDigest) throws IOException {
        IX509PublicKeyCertificate cert;
        SignerInfo signerInfo = signature.getSignerInfo(signerInfoId);
        byte[] encodedSignatureBytes = signerInfo.getSignature().getBytes();
        try {
            cert = signature.getSignerCertificate(signerInfoId);
        }
        catch (CertificateException e) {
            VSSignature state = new VSSignature(signedDigest, 3);
            VSMathematicalSignature basicState = new VSMathematicalSignature(3);
            basicState.addMessage(CommonValidationMessages.ERROR_CERTIFICATE((Exception)e));
            state.setSignatureState((IVSMathematicalSignature)basicState);
            return state;
        }
        if (cert == null) {
            VSSignature state = new VSSignature(signedDigest, 3);
            VSMathematicalSignature basicState = new VSMathematicalSignature(3);
            basicState.addMessage(CommonValidationMessages.ERROR_CERTIFICATE_NOT_AVAILABLE());
            state.setSignatureState((IVSMathematicalSignature)basicState);
            return state;
        }
        AlgorithmIdentifier signatureAlgorithm = signerInfo.getSignatureAlgorithm();
        try {
            String digestAlgoOID = signerInfo.getDigestAlgorithm().getAlgorithm();
            String digestAlgoName = SignatureAlgorithm.getHashAlgorithmName((String)digestAlgoOID);
            EncodedSignature encodedSignature = EncodedSignature.create((byte[])encodedSignatureBytes, (String)signatureAlgorithm.getAlgorithm(), (byte[])signatureAlgorithm.getParametersEncoded(), (IX509PublicKeyCertificate)cert, (String)digestAlgoName);
            EncodedSignatureEntry entry = encodedSignature.getEntry();
            ISignatureEntryValidator pkcs1Validator = SignatureEntryValidatorFactory.get().createValidator((ISignatureEntry)entry, (IArgs)Args.create());
            IVSSignatureEntry state = (IVSSignatureEntry)pkcs1Validator.validate((ISignatureContainerEntry)entry, signedDigest, (IValidationParameters)new ValidationParameters());
            return state.getSignatureState();
        }
        catch (GeneralSecurityException e) {
            VSSignature state = new VSSignature(signedDigest, 3);
            VSMathematicalSignature basicState = new VSMathematicalSignature(3);
            basicState.addMessage(CommonValidationMessages.ERROR_SIGNATURE((Exception)e));
            state.setSignatureState((IVSMathematicalSignature)basicState);
            return state;
        }
    }

    protected IVSSignature validateSignedAttributes(CMSSignature signature, int signerInfoId, IDigest dataDigest) throws IOException {
        IDigester digester;
        try {
            digester = signature.getDigester(signerInfoId);
        }
        catch (NoSuchAlgorithmException e) {
            IValidationMessage msg = CommonValidationMessages.ERROR_ALGORITHM_UNKNOWN((Exception)e, (String)signature.getHashAlgorithmOID(signerInfoId));
            VSSignature state = new VSSignature(dataDigest);
            state.setSignatureState(VSMathematicalSignature.createInvalid((IValidationMessage)msg));
            state.addDigestState((IVSDigest)VSDigest.createInvalid((IValidationMessage)msg));
            return state;
        }
        IDigest signedDigest = digester.digest(signature.getSignedContent());
        IVSSignature state = this.basicValidateSignedAttributes(signature, signerInfoId, signedDigest);
        this.basicValidateDataDigest(signature, dataDigest, state);
        return state;
    }
}

