/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSTools;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.app.validation.ISignatureContainerEntryExtender;
import de.intarsys.security.method.pdf.signature.IDocumentChangeLog;
import de.intarsys.security.method.pdf.signature.PDFDocumentSecurityStore;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainer;
import de.intarsys.security.method.pdf.validation.PDFValidationDataExtender;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.security.validation.IExtendedValidationDataSupport;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorViewport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PDFSignatureContainerEntry
implements ISignatureContainerEntry,
IExtendedValidationDataSupport,
IAdapterSupport {
    private static final Logger Log = LoggerFactory.getLogger(PDFSignatureContainerEntry.class);
    private final PDSignature pdSignature;
    private final PDFSignatureContainer signatureContainer;

    protected PDFSignatureContainerEntry(PDFSignatureContainer signatureContainer, PDSignature pdSignature) {
        this.signatureContainer = signatureContainer;
        this.pdSignature = pdSignature;
    }

    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == ISignatureContainerEntryExtender.class) {
            return (T)((Object)new PDFValidationDataExtender());
        }
        return null;
    }

    public final Object getAttribute(Object key) {
        return this.getPDSignature().getAttribute(key);
    }

    public PDDocument getDoc() {
        return this.getPDSignature().getDoc();
    }

    public IExtendedValidationData getExtendedValidationData() {
        return PDFDocumentSecurityStore.get(this.getDoc());
    }

    public abstract AlgorithmSpec getHashAlgorithmSpec();

    public Object getImpl() {
        return this.getPDSignature();
    }

    public PDSignature getPDSignature() {
        return this.pdSignature;
    }

    public PDFSignatureContainer getSignatureContainer() {
        return this.signatureContainer;
    }

    public ILocator getSignedDocument() {
        COSTools.IRevision revision = this.getSignedRevision();
        if (revision != null) {
            return revision.createLocator();
        }
        ILocator docLocator = this.getDoc().getLocator();
        if (docLocator == null) {
            return null;
        }
        COSArray ranges = this.getPDSignature().cosGetByteRange();
        if (ranges == null || ranges.size() < 2 || ranges.size() % 2 != 0) {
            return null;
        }
        long offset = ranges.get(ranges.size() - 2).asInteger().longValue();
        long length = ranges.get(ranges.size() - 1).asInteger().longValue();
        long start = 0L;
        long totalLength = offset + length;
        LocatorViewport locator = new LocatorViewport(docLocator);
        locator.setStart(start);
        locator.setEnd(start + totalLength);
        locator.setReadOnly();
        return locator;
    }

    public COSTools.IRevision getSignedRevision() {
        IDocumentChangeLog changeLog = this.getSignatureContainer().getDocumentChangeLog();
        COSIndirectObject signatureObject = this.getPDSignature().cosGetObject().getIndirectObject();
        return changeLog.getDefiningRevision(signatureObject);
    }

    public final Object removeAttribute(Object key) {
        return this.getPDSignature().removeAttribute(key);
    }

    public final Object setAttribute(Object key, Object o) {
        return this.getPDSignature().setAttribute(key, o);
    }
}

