/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.pdf.pd.PDDSS;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.common.OCSPTools;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.attribute.Attribute;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class PDFDocumentSecurityStore
implements IExtendedValidationData {
    private static final Logger Log = LoggerFactory.getLogger(PDFDocumentSecurityStore.class);
    private static final Attribute ATTR_DOCUMENTSECURITYSTORE = new Attribute(PDFDocumentSecurityStore.class.getName());
    private final PDDocument doc;
    private SoftReference<List<IX509PublicKeyCertificate>> certificates;
    private SoftReference<List<IX509CRL>> crls;
    private SoftReference<List<IOCSPResponse>> ocspResponses;
    private boolean changed = false;

    public static PDFDocumentSecurityStore get(PDDocument doc) {
        PDFDocumentSecurityStore store = (PDFDocumentSecurityStore)doc.getAttribute((Object)ATTR_DOCUMENTSECURITYSTORE);
        if (store == null) {
            store = new PDFDocumentSecurityStore(doc);
            doc.setAttribute((Object)ATTR_DOCUMENTSECURITYSTORE, (Object)store);
        }
        return store;
    }

    protected PDFDocumentSecurityStore(PDDocument doc) {
        this.doc = doc;
    }

    public boolean addCertificate(IX509PublicKeyCertificate certificate) throws IOException {
        List<IX509PublicKeyCertificate> cached;
        if (this.containsCertificate(certificate)) {
            return false;
        }
        PDDSS dss = this.createDSS();
        try {
            byte[] bCert = certificate.getEncoded();
            dss.addCert(bCert);
        }
        catch (CertificateEncodingException e) {
            throw new IOException(e);
        }
        this.changed = true;
        if (this.certificates != null && (cached = this.certificates.get()) != null) {
            cached.add(certificate);
        }
        return true;
    }

    public boolean addCRL(IX509CRL crl) throws IOException {
        List<IX509CRL> cached;
        if (this.containsCRL(crl)) {
            return false;
        }
        PDDSS dss = this.createDSS();
        try {
            byte[] bCrl = crl.getEncoded();
            dss.addCRL(bCrl);
        }
        catch (CRLException e) {
            throw new IOException(e);
        }
        this.changed = true;
        if (this.crls != null && (cached = this.crls.get()) != null) {
            cached.add(crl);
        }
        return true;
    }

    public boolean addOCSPResponse(IOCSPResponse ocspResponse) throws IOException {
        List<IOCSPResponse> cached;
        if (this.containsOCSPResponse(ocspResponse)) {
            return false;
        }
        PDDSS dss = this.createDSS();
        byte[] bOcspResponse = OCSPTools.encodeAsn1OcspResponse((IOCSPResponse)ocspResponse);
        dss.addOCSP(bOcspResponse);
        this.changed = true;
        if (this.ocspResponses != null && (cached = this.ocspResponses.get()) != null) {
            cached.add(ocspResponse);
        }
        return true;
    }

    protected List<IX509PublicKeyCertificate> basicGetCertificates() {
        List<IX509PublicKeyCertificate> result = null;
        if (this.certificates != null) {
            result = this.certificates.get();
        }
        if (result == null) {
            result = this.basicLoadCertificates();
            this.certificates = new SoftReference<List<IX509PublicKeyCertificate>>(result);
        }
        return result;
    }

    protected List<IX509CRL> basicGetCRLs() {
        List<IX509CRL> result = null;
        if (this.crls != null) {
            result = this.crls.get();
        }
        if (result == null) {
            result = this.basicLoadCRLs();
            this.crls = new SoftReference<List<IX509CRL>>(result);
        }
        return result;
    }

    protected List<IOCSPResponse> basicGetOCSPResponses() {
        List<IOCSPResponse> result = null;
        if (this.ocspResponses != null) {
            result = this.ocspResponses.get();
        }
        if (result == null) {
            result = this.basicLoadOCSPResponses();
            this.ocspResponses = new SoftReference<List<IOCSPResponse>>(result);
        }
        return result;
    }

    protected List<IX509PublicKeyCertificate> basicLoadCertificates() {
        byte[][] bCertificates;
        ArrayList<IX509PublicKeyCertificate> certificates = new ArrayList<IX509PublicKeyCertificate>();
        PDDSS dss = this.getDSS();
        if (dss == null) {
            return certificates;
        }
        for (byte[] bCertificate : bCertificates = dss.getCerts()) {
            try {
                IX509PublicKeyCertificate certificate = X509CertificateFactory.get().createPublicKeyCertificate(bCertificate);
                certificates.add(certificate);
            }
            catch (CertificateException e) {
                Log.warn("Unable to parse certificate: {}", (Object)e.getMessage(), (Object)e);
                if (!Log.isEnabledForLevel(Level.DEBUG)) continue;
                Log.debug("Failed certificate's content: {}", (Object)Base64.getEncoder().encodeToString(bCertificate));
            }
        }
        return certificates;
    }

    protected List<IX509CRL> basicLoadCRLs() {
        byte[][] bCrls;
        ArrayList<IX509CRL> crls = new ArrayList<IX509CRL>();
        PDDSS dss = this.getDSS();
        if (dss == null) {
            return crls;
        }
        for (byte[] bCrl : bCrls = dss.getCRLs()) {
            ByteArrayInputStream is = new ByteArrayInputStream(bCrl);
            try {
                IX509CRL crl = X509CertificateFactory.get().createCRL((InputStream)is);
                crls.add(crl);
            }
            catch (Exception e) {
                Log.warn("Unable to parse CRL: {}", (Object)e.getMessage(), (Object)e);
                if (!Log.isEnabledForLevel(Level.DEBUG)) continue;
                Log.debug("Failed CRL's content: {}", (Object)Base64.getEncoder().encodeToString(bCrl));
            }
        }
        return crls;
    }

    protected List<IOCSPResponse> basicLoadOCSPResponses() {
        byte[][] bOcspResponses;
        ArrayList<IOCSPResponse> ocspResponses = new ArrayList<IOCSPResponse>();
        PDDSS dss = this.getDSS();
        if (dss == null) {
            return ocspResponses;
        }
        for (byte[] bOcspResponse : bOcspResponses = dss.getOCSPs()) {
            try {
                IOCSPResponse resultResponse = OCSPTools.decodeOCSPResponse((byte[])bOcspResponse);
                ocspResponses.add(resultResponse);
            }
            catch (Exception e) {
                Log.warn("Unable to parse OCSP response: {}", (Throwable)e);
                if (!Log.isEnabledForLevel(Level.DEBUG)) continue;
                Log.debug("Failed OCSP response's content: {}", (Object)Base64.getEncoder().encodeToString(bOcspResponse));
            }
        }
        return ocspResponses;
    }

    public boolean containsCertificate(IX509PublicKeyCertificate certificate) {
        return this.basicGetCertificates().contains(certificate);
    }

    public boolean containsCRL(IX509CRL crl) {
        return this.basicGetCRLs().contains(crl);
    }

    public boolean containsOCSPResponse(IOCSPResponse ocspResponse) {
        return this.basicGetOCSPResponses().contains(ocspResponse);
    }

    protected PDDSS createDSS() {
        PDDSS dss = this.getDoc().getDSS();
        if (dss == null) {
            dss = (PDDSS)PDDSS.META.createNew();
            this.getDoc().setDSS(dss);
        }
        return dss;
    }

    public Stream<IX509PublicKeyCertificate> getCertificates() {
        return this.basicGetCertificates().stream();
    }

    public Stream<IX509CRL> getCRLs() {
        return this.basicGetCRLs().stream();
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    protected PDDSS getDSS() {
        return this.getDoc().getDSS();
    }

    public Stream<IOCSPResponse> getOCSPResponses() {
        return this.basicGetOCSPResponses().stream();
    }

    public boolean isChanged() {
        return this.changed;
    }
}

