/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.common;

import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PDSignatureTools {
    public static List<PDAFSignatureField> getFields(PDDocument doc) {
        if (doc == null || doc.getAcroForm() == null) {
            return Collections.emptyList();
        }
        List fields = doc.getAcroForm().getFields();
        if (fields == null) {
            return Collections.emptyList();
        }
        ArrayList<PDAFSignatureField> result = new ArrayList<PDAFSignatureField>(3);
        for (PDAcroFormField field : doc.getAcroForm().collectLeafFields()) {
            if (!field.isTypeSig()) continue;
            result.add((PDAFSignatureField)field);
        }
        return result;
    }

    private static List<PDAFSignatureField> getFields(PDDocument doc, ITest<PDAFSignatureField> test) {
        List<PDAFSignatureField> fields = PDSignatureTools.getFields(doc);
        if (fields.isEmpty()) {
            return fields;
        }
        ArrayList<PDAFSignatureField> result = new ArrayList<PDAFSignatureField>(fields.size());
        for (PDAFSignatureField sigField : fields) {
            if (!test.accept(sigField)) continue;
            result.add(sigField);
        }
        return result;
    }

    public static List<PDAFSignatureField> getSignedFields(PDDocument doc) {
        return PDSignatureTools.getFields(doc, new ITest<PDAFSignatureField>(){

            @Override
            public boolean accept(PDAFSignatureField obj) {
                return obj.isSigned();
            }
        });
    }

    public static List<PDAFSignatureField> getUnsignedFields(PDDocument doc) {
        return PDSignatureTools.getFields(doc, new ITest<PDAFSignatureField>(){

            @Override
            public boolean accept(PDAFSignatureField obj) {
                return !obj.isSigned();
            }
        });
    }

    private PDSignatureTools() {
    }

    static interface ITest<T> {
        public boolean accept(T var1);
    }
}

