/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.signature.history;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAcroFormNode;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.signature.change.AllowedChange;
import de.intarsys.pdf.signature.change.DefaultChange;
import de.intarsys.pdf.signature.change.FieldValueChange;
import de.intarsys.pdf.signature.change.FormChangeType;
import de.intarsys.pdf.signature.history.FontChangeIdentifier;
import de.intarsys.pdf.signature.history.HistoryTools;
import de.intarsys.pdf.signature.history.IChangeIdentifier;
import de.intarsys.pdf.signature.history.IChangeIdentifierContext;
import de.intarsys.pdf.signature.history.PACKAGE;
import de.intarsys.security.validation.IDocumentChange;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FormChangeIdentifier
implements IChangeIdentifier {
    private static final Attribute ATTR_VALUECHANGES = new Attribute("FormChangeIdentifier_values");
    private static final Attribute ATTR_DEFAULTCHANGES = new Attribute("FormChangeIdentifier_default");
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected List<IDocumentChange> basicCompareAcroForm(final COSIndirectObject baseObject, COSDictionary baseDict, COSDictionary newDict, final IChangeIdentifierContext context) throws IOException, COSLoadException {
        final ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        if (baseDict == null) {
            if (newDict != null) {
                changes.add(new DefaultChange(Msg.getString("FormChangeIdentifier.MessageFormChanged", new Object[]{baseObject.getKey()})));
            }
        } else if (newDict == null) {
            changes.add(new DefaultChange(Msg.getString("FormChangeIdentifier.MessageFormChanged", new Object[]{baseObject.getKey()})));
        } else {
            HistoryTools.compareDictionary(baseDict, newDict, new HistoryTools.IEntryComparator(){

                @Override
                public void compare(COSName key, COSObject baseEntry, COSObject newEntry) throws IOException, COSLoadException {
                    if (PDAcroForm.DK_Fields.equals((Object)key)) {
                        changes.addAll(FormChangeIdentifier.this.compareFields(baseEntry.getIndirectObject(), newEntry.getIndirectObject(), context));
                    } else if (PDAcroForm.DK_DA.equals((Object)key)) {
                        if (!HistoryTools.equals(baseEntry, newEntry)) {
                            changes.add(new AllowedChange(Msg.getString("FormChangeIdentifier.MessageDefaultAppearanceChanged", new Object[0])));
                        }
                    } else if (PDAcroForm.DK_DR.equals((Object)key)) {
                        if (!HistoryTools.equals(baseEntry, newEntry)) {
                            changes.add(new AllowedChange(Msg.getString("FormChangeIdentifier.MessageDefaultResourcesChanged", new Object[0])));
                        }
                    } else {
                        if (HistoryTools.skipCompare(baseEntry, newEntry)) {
                            return;
                        }
                        if (!HistoryTools.equals(baseEntry, newEntry)) {
                            changes.add(new DefaultChange(Msg.getString("FormChangeIdentifier.MessageFormChanged", new Object[]{baseObject.getKey()})));
                        }
                    }
                    HistoryTools.setProcessed(context, baseEntry, newEntry);
                }
            });
        }
        return changes;
    }

    protected List<IDocumentChange> compareAcroForm(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        COSDictionary baseDict = baseObject.dereference().asDictionary();
        COSDictionary newDict = newObject.dereference().asDictionary();
        return this.basicCompareAcroForm(baseObject, baseDict, newDict, context);
    }

    protected List<IDocumentChange> compareDefaultResources(final COSIndirectObject baseObject, COSDictionary baseResources, COSDictionary newResources, final IChangeIdentifierContext context) throws IOException, COSLoadException {
        final ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        if (baseResources != null) {
            if (newResources == null) {
                changes.add(new DefaultChange(Msg.getString("FormChangeIdentifier.MessageDefaultResourcesRemoved", new Object[0])));
            } else {
                HistoryTools.compareDictionary(baseResources, newResources, new HistoryTools.IEntryComparator(){

                    @Override
                    public void compare(COSName key, COSObject baseEntry, COSObject newEntry) throws IOException, COSLoadException {
                        if (PDResources.CN_RT_Font.equals((Object)key)) {
                            changes.addAll(FormChangeIdentifier.this.compareFontResources(baseObject, baseEntry.asDictionary(), newEntry.asDictionary(), context));
                        } else {
                            if (HistoryTools.skipCompare(baseEntry, newEntry)) {
                                return;
                            }
                            if (!HistoryTools.equals(baseEntry, newEntry)) {
                                if (baseEntry.isNull() && !newEntry.isNull()) {
                                    changes.add(new AllowedChange(Msg.getString("FormChangeIdentifier.MessageDefaultResourcesAdded", new Object[]{baseObject.getKey()})));
                                } else {
                                    changes.add(new AllowedChange(Msg.getString("FormChangeIdentifier.MessageDefaultResourcesChanged", new Object[]{baseObject.getKey()})));
                                }
                            }
                        }
                    }
                });
            }
        }
        return changes;
    }

    protected List<IDocumentChange> compareDefaultResources(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        if (baseObject == null) {
            if (newObject != null) {
                changes.add(new AllowedChange(Msg.getString("FormChangeIdentifier.MessageDefaultResourcesAdded", new Object[]{newObject.getKey()})));
            }
        } else if (newObject == null) {
            changes.add(new DefaultChange(Msg.getString("FormChangeIdentifier.MessageDefaultResourcesRemoved", new Object[]{baseObject.getKey()})));
        } else {
            COSDictionary baseResources = baseObject.dereference().asDictionary();
            COSDictionary newResources = newObject.dereference().asDictionary();
            changes.addAll(this.compareDefaultResources(baseObject, baseResources, newResources, context));
        }
        return changes;
    }

    protected List<IDocumentChange> compareField(COSDocumentElement baseObject, COSDocumentElement newObject, final IChangeIdentifierContext context) throws IOException, COSLoadException {
        COSIndirectObject baseRef = null;
        if (baseObject.isReference()) {
            baseRef = (COSIndirectObject)baseObject;
        } else if (baseObject.dereference().isIndirect()) {
            baseRef = baseObject.dereference().getIndirectObject();
        }
        if (baseRef != null) {
            if (context.isProcessed(baseRef)) {
                return Collections.emptyList();
            }
            context.setProcessed(baseRef);
        }
        final ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        COSDictionary baseDict = baseObject.dereference().asDictionary();
        final PDAcroFormField baseField = (PDAcroFormField)PDAcroFormField.META.createFromCos((COSObject)baseDict);
        COSDictionary newDict = newObject.dereference().asDictionary();
        PDAcroFormField newField = (PDAcroFormField)PDAcroFormField.META.createFromCos((COSObject)newDict);
        if (baseDict == null) {
            if (newDict != null) {
                changes.addAll(this.createDefaultChanges(newField, context));
            }
        } else if (newDict == null) {
            changes.addAll(this.createDefaultChanges(baseField, context));
        } else {
            HistoryTools.compareDictionary(baseDict, newDict, new HistoryTools.IEntryComparator(){

                @Override
                public void compare(COSName key, COSObject baseEntry, COSObject newEntry) throws IOException, COSLoadException {
                    if (PDAnnotation.DK_P.equals((Object)key)) {
                        return;
                    }
                    if (PDAcroFormField.DK_V.equals((Object)key) || PDAFSignatureField.DK_Lock.equals((Object)key) || PDAnnotation.DK_AP.equals((Object)key) || PDAnnotation.DK_AS.equals((Object)key) || PDAnnotation.DK_M.equals((Object)key) || PDAnnotation.DK_Rect.equals((Object)key)) {
                        if (!HistoryTools.equals(baseEntry, newEntry)) {
                            changes.addAll(FormChangeIdentifier.this.createFieldValueChanges(baseField, context));
                        }
                    } else if (PDAnnotation.DK_F.equals((Object)key) && !HistoryTools.equals(baseEntry, newEntry) && FormChangeIdentifier.this.isAllowedAnnotationFlagChange(baseEntry, newEntry)) {
                        changes.addAll(FormChangeIdentifier.this.createFieldValueChanges(baseField, context));
                    } else if (PDAcroFormField.DK_Ff.equals((Object)key) && !HistoryTools.equals(baseEntry, newEntry) && FormChangeIdentifier.this.isAllowedFieldFlagChange(baseEntry, newEntry)) {
                        changes.addAll(FormChangeIdentifier.this.createFieldValueChanges(baseField, context));
                    } else if (PDAcroFormField.DK_TU.equals((Object)key) && !HistoryTools.equals(baseEntry, newEntry) && FormChangeIdentifier.this.isAllowedAlternateFieldNameChange(baseEntry, newEntry)) {
                        changes.addAll(FormChangeIdentifier.this.createFieldValueChanges(baseField, context));
                    } else if (PDAcroForm.DK_Fields.equals((Object)key)) {
                        changes.addAll(FormChangeIdentifier.this.compareFields(baseEntry.getIndirectObject(), newEntry.getIndirectObject(), context));
                    } else if ((PDAcroFormNode.DK_DR.equals((Object)key) || PDAcroFormNode.DK_DA.equals((Object)key)) && FormChangeIdentifier.this.isEmptyField(baseField)) {
                        if (!HistoryTools.equals(baseEntry, newEntry)) {
                            changes.add(new AllowedChange(Msg.getString("FormChangeIdentifier.MessageDefaultResourcesChanged", new Object[0])));
                        }
                    } else if (!HistoryTools.equals(baseEntry, newEntry)) {
                        changes.addAll(FormChangeIdentifier.this.createDefaultChanges(baseField, context));
                    }
                    HistoryTools.setProcessed(context, baseEntry, newEntry);
                }
            });
        }
        return changes;
    }

    protected List<IDocumentChange> compareFields(COSArray baseFields, COSArray newFields, IChangeIdentifierContext context) throws IOException, COSLoadException {
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        if (baseFields == null) {
            if (newFields != null) {
                // empty if block
            }
        } else if (newFields != null) {
            Set<HistoryTools.ObjectKey> allKeys = HistoryTools.collectObjectKeys(baseFields, newFields);
            Map<HistoryTools.ObjectKey, COSObject> baseMap = HistoryTools.mapObjects(baseFields);
            Map<HistoryTools.ObjectKey, COSObject> newMap = HistoryTools.mapObjects(newFields);
            for (HistoryTools.ObjectKey key : allKeys) {
                COSObject cosBaseField = baseMap.get(key);
                PDAcroFormField baseField = (PDAcroFormField)PDAcroFormField.META.createFromCos(cosBaseField);
                COSObject cosNewField = newMap.get(key);
                PDAcroFormField newField = (PDAcroFormField)PDAcroFormField.META.createFromCos(cosNewField);
                if (baseField == null) {
                    if (newField == null) continue;
                    continue;
                }
                if (newField == null) continue;
                changes.addAll(this.compareField((COSDocumentElement)cosBaseField, (COSDocumentElement)cosNewField, context));
            }
        }
        return changes;
    }

    protected List<IDocumentChange> compareFields(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        if (baseObject == null) {
            if (newObject != null) {
                changes.add(new DefaultChange(Msg.getString("FormChangeIdentifier.MessageFormChanged", new Object[]{newObject.getKey()})));
            }
        } else if (newObject == null) {
            changes.add(new DefaultChange(Msg.getString("FormChangeIdentifier.MessageFormChanged", new Object[]{baseObject.getKey()})));
        } else {
            COSArray baseFields = baseObject.dereference().asArray();
            COSArray newFields = newObject.dereference().asArray();
            changes.addAll(this.compareFields(baseFields, newFields, context));
        }
        return changes;
    }

    protected List<IDocumentChange> compareFontResources(final COSIndirectObject baseObject, COSDictionary baseFonts, COSDictionary newFonts, final IChangeIdentifierContext context) throws IOException, COSLoadException {
        final ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        if (baseFonts == null) {
            if (newFonts != null) {
                changes.add(new AllowedChange(Msg.getString("FormChangeIdentifier.MessageFontResourcesadded", new Object[0])));
            }
        } else if (newFonts == null) {
            changes.add(new AllowedChange(Msg.getString("FormChangeIdentifier.MessageFontResourcesRemoved", new Object[0])));
        } else {
            HistoryTools.compareDictionary(baseFonts, newFonts, new HistoryTools.IEntryComparator(){

                @Override
                public void compare(COSName key, COSObject baseEntry, COSObject newEntry) throws IOException, COSLoadException {
                    changes.addAll(new FontChangeIdentifier().basicCompareFont(baseObject, baseEntry.asDictionary(), newEntry.asDictionary(), context));
                    HistoryTools.setProcessed(context, baseEntry, newEntry);
                }
            });
        }
        return changes;
    }

    protected List<IDocumentChange> compareFontResources(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        if (baseObject == null) {
            if (newObject != null) {
                changes.add(new AllowedChange(Msg.getString("FormChangeIdentifier.MessageFontResourcesAdded", new Object[]{newObject.getKey()})));
            }
        } else if (newObject == null) {
            changes.add(new DefaultChange(Msg.getString("FormChangeIdentifier.MessageFontResourcesRemoved", new Object[]{baseObject.getKey()})));
        } else {
            COSDictionary baseResources = baseObject.dereference().asDictionary();
            COSDictionary newResources = newObject.dereference().asDictionary();
            changes.addAll(this.compareFontResources(baseObject, baseResources, newResources, context));
        }
        return changes;
    }

    protected List<IDocumentChange> createDefaultChanges(PDAcroFormField node, IChangeIdentifierContext context) {
        Set<String> processed = this.getFieldList(context, ATTR_VALUECHANGES);
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        List fields = node.collectLeafFields();
        for (PDAcroFormField field : fields) {
            if (processed.contains(field.getQualifiedName())) continue;
            processed.add(field.getQualifiedName());
            changes.add(new DefaultChange(Msg.getString("FormChangeIdentifier.MessageFieldChanged", new Object[]{field.getQualifiedName(), node.cosGetObject().getIndirectObject().getKey()})));
            context.setProcessed(field.cosGetObject().getIndirectObject());
            for (PDAnnotation annot : field.getAnnotations()) {
                context.setProcessed(annot.cosGetObject().getIndirectObject());
            }
        }
        return changes;
    }

    protected List<IDocumentChange> createFieldValueChanges(PDAcroFormField node, IChangeIdentifierContext context) {
        Set<String> processed = this.getFieldList(context, ATTR_DEFAULTCHANGES);
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        List fields = node.collectLeafFields();
        for (PDAcroFormField field : fields) {
            if (processed.contains(field.getQualifiedName())) continue;
            processed.add(field.getQualifiedName());
            String name = field.getQualifiedName();
            String type = FormChangeType.of(field);
            changes.add(new FieldValueChange(name, type));
            context.setProcessed(field.cosGetObject().getIndirectObject());
            for (PDAnnotation annot : field.getAnnotations()) {
                context.setProcessed(annot.cosGetObject().getIndirectObject());
            }
        }
        return changes;
    }

    protected Set<String> getFieldList(IChangeIdentifierContext context, Attribute attribute) {
        HashSet fields = (HashSet)context.getAttribute(attribute);
        if (fields == null) {
            fields = new HashSet();
            context.setAttribute(attribute, fields);
        }
        return fields;
    }

    @Override
    public List<IDocumentChange> identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        PDDocument doc = PDDocument.createFromCos((COSDocument)context.getBaseDocument());
        PDAcroForm form = doc.getAcroForm();
        if (form == null) {
            return Collections.emptyList();
        }
        return this.identifyChange(baseObject, newObject, context, form);
    }

    protected List<IDocumentChange> identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context, PDAcroForm form) throws IOException, COSLoadException {
        COSIndirectObject currentFontsRef;
        COSIndirectObject currentNodeRef = form.cosGetObject().getIndirectObject();
        if (currentNodeRef == baseObject) {
            return this.compareAcroForm(baseObject, newObject, context);
        }
        COSIndirectObject currentFieldsRef = form.cosGetField(PDAcroForm.DK_Fields).getIndirectObject();
        if (currentFieldsRef == baseObject) {
            return this.compareFields(baseObject, newObject, context);
        }
        COSIndirectObject currentDRRef = form.cosGetField(PDAcroForm.DK_DR).getIndirectObject();
        if (currentDRRef == baseObject) {
            return this.compareDefaultResources(baseObject, newObject, context);
        }
        COSDictionary currentDR = form.cosGetField(PDAcroForm.DK_DR).asDictionary();
        if (currentDR != null && (currentFontsRef = currentDR.get(PDResources.CN_RT_Font).getIndirectObject()) == baseObject) {
            return this.compareFontResources(baseObject, newObject, context);
        }
        List fields = form.getFields();
        if (fields != null) {
            for (PDAcroFormField field : fields) {
                List<IDocumentChange> result = this.identifyChange(baseObject, newObject, context, field);
                if (result.isEmpty()) continue;
                return result;
            }
        }
        return Collections.emptyList();
    }

    protected List<IDocumentChange> identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context, PDAcroFormField currentField) throws IOException, COSLoadException {
        COSIndirectObject currentNodeRef = currentField.cosGetObject().getIndirectObject();
        if (currentNodeRef == baseObject) {
            return this.compareField((COSDocumentElement)baseObject, (COSDocumentElement)newObject, context);
        }
        if (HistoryTools.isEntry(currentField.cosGetDict(), new COSName[]{PDAcroFormField.DK_V, PDAnnotation.DK_AP, PDAnnotation.DK_AS, PDAnnotation.DK_M}, baseObject)) {
            context.setProcessed(baseObject);
            return this.createFieldValueChanges(currentField, context);
        }
        COSDictionary appearanceDict = currentField.cosGetField(PDAnnotation.DK_AP).asDictionary();
        if (appearanceDict != null && HistoryTools.isEntry(appearanceDict, baseObject)) {
            context.setProcessed(baseObject);
            return this.createFieldValueChanges(currentField, context);
        }
        List fields = currentField.getKids();
        if (fields != null) {
            for (PDAcroFormField field : fields) {
                List<IDocumentChange> result = this.identifyChange(baseObject, newObject, context, field);
                if (result.isEmpty()) continue;
                return result;
            }
        }
        return Collections.emptyList();
    }

    protected boolean isAllowedAlternateFieldNameChange(COSObject baseEntry, COSObject newEntry) {
        return baseEntry.isNull();
    }

    protected boolean isAllowedAnnotationFlagChange(COSObject baseEntry, COSObject newEntry) {
        int newFlags;
        int baseFlags = baseEntry.getValueInteger(0);
        if ((baseFlags | 0x80) != ((newFlags = newEntry.getValueInteger(0)) | 0x80)) {
            return false;
        }
        int baseLocked = baseFlags & 0x80;
        int newLocked = newFlags & 0x80;
        return baseLocked != 1 || newLocked != 0;
    }

    protected boolean isAllowedFieldFlagChange(COSObject baseEntry, COSObject newEntry) {
        int newFlags;
        int baseFlags = baseEntry.getValueInteger(0);
        if ((baseFlags | 1) != ((newFlags = newEntry.getValueInteger(0)) | 1)) {
            return false;
        }
        int baseReadOnly = baseFlags & 1;
        int newReadOnly = newFlags & 1;
        return baseReadOnly != 1 || newReadOnly != 0;
    }

    protected boolean isEmptyField(PDAcroFormField field) {
        return "".equals(field.getValueString());
    }
}

