/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.signature.history;

import de.intarsys.pdf.signature.history.CatalogChangeIdentifier;
import de.intarsys.pdf.signature.history.DSSChangeIdentifier;
import de.intarsys.pdf.signature.history.FallbackChangeIdentifier;
import de.intarsys.pdf.signature.history.FontChangeIdentifier;
import de.intarsys.pdf.signature.history.FormChangeIdentifier;
import de.intarsys.pdf.signature.history.IChangeIdentifier;
import de.intarsys.pdf.signature.history.IChangeIdentifierRegistry;
import de.intarsys.pdf.signature.history.IdentityChangeIdentifier;
import de.intarsys.pdf.signature.history.PageChangeIdentifier;
import de.intarsys.pdf.signature.history.StructTreeChangeIdentifier;
import de.intarsys.pdf.signature.history.TrailerChangeIdentifier;
import de.intarsys.pdf.signature.history.XRefStreamChangeIdentifier;
import java.util.ArrayList;
import java.util.List;

public class DefaultChangeIdentifierRegistry
implements IChangeIdentifierRegistry {
    private List<IChangeIdentifier> identifiers = new ArrayList<IChangeIdentifier>();

    public DefaultChangeIdentifierRegistry() {
        this.registerDefaultIdentifiers();
    }

    @Override
    public List<IChangeIdentifier> getIdentifiers() {
        return this.identifiers;
    }

    protected void registerDefaultIdentifiers() {
        this.registerIdentifier(new IdentityChangeIdentifier());
        this.registerIdentifier(new XRefStreamChangeIdentifier());
        this.registerIdentifier(new CatalogChangeIdentifier());
        this.registerIdentifier(new StructTreeChangeIdentifier());
        this.registerIdentifier(new DSSChangeIdentifier());
        this.registerIdentifier(new TrailerChangeIdentifier());
        this.registerIdentifier(new FormChangeIdentifier());
        this.registerIdentifier(new PageChangeIdentifier());
        this.registerIdentifier(new FontChangeIdentifier());
        this.registerIdentifier(new FallbackChangeIdentifier());
    }

    @Override
    public void registerIdentifier(IChangeIdentifier changeIdentifier) {
        this.identifiers.add(changeIdentifier);
    }

    @Override
    public void unregisterIdentifier(IChangeIdentifier changeIdentifier) {
        this.identifiers.remove(changeIdentifier);
    }
}

