/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.signature.appearance;

import de.intarsys.pdf.design.shape.Text;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import de.intarsys.pdf.layout.parser.PDLAbstractDocumentParser;
import de.intarsys.pdf.layout.parser.PDLParseException;
import de.intarsys.pdf.signature.appearance.PACKAGE;
import de.intarsys.security.certificate.info.IPublicKeyInfo;
import de.intarsys.security.certificate.info.X500SimpleName;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.List;
import java.util.Objects;

public class CertificateText
extends Text {
    private static List<String> INFO_KEYS = List.of("CN", "T", "EMAILADDRESS", "C", "DC", "L", "OU", "O", "ST", "STREET", "UID");
    private LocalDateTime date;
    private boolean includeDate;
    private boolean includeKeyInfoIssuer;
    private boolean includeKeyInfoSubject;
    private boolean includeSignerName;
    private IPublicKeyInfo keyInfo;

    private static final DateTimeFormatter createDateFormatter() {
        return new DateTimeFormatterBuilder().appendPattern(PACKAGE.Messages.getString("CertificateAppearanceCreator.DateFormat", new Object[0])).toFormatter();
    }

    public CertificateText(IPublicKeyInfo keyInfo, LocalDateTime date, IArgs args) {
        this.init(args);
        this.keyInfo = Objects.requireNonNull(keyInfo);
        this.date = date;
    }

    protected boolean parseBodyDate(PDLAbstractDocumentParser parser, boolean newLine) throws IOException, PDLParseException {
        String dateString;
        if (!this.includeDate) {
            return false;
        }
        if (newLine) {
            parser.newLine(true);
            parser.newLine(true);
        }
        if (!StringTools.isEmpty((String)(dateString = CertificateText.createDateFormatter().format(ZonedDateTime.of(this.date, ZoneId.systemDefault()))))) {
            parser.parseFragment((Reader)new StringReader(PACKAGE.Messages.getString("CertificateAppearanceCreator.label.date", new Object[0]) + dateString));
        }
        return true;
    }

    protected boolean parseBodyIssuer(PDLAbstractDocumentParser parser, boolean newLine) throws IOException, PDLParseException {
        if (!this.includeKeyInfoIssuer) {
            return false;
        }
        if (newLine) {
            parser.newLine(true);
            parser.newLine(true);
        }
        parser.parseFragment((Reader)new StringReader(PACKAGE.Messages.getString("CertificateAppearanceCreator.label.issuer", new Object[0])));
        this.parseDn(parser, this.keyInfo.getIssuer());
        return true;
    }

    protected boolean parseBodySubject(PDLAbstractDocumentParser parser, boolean newLine) throws IOException, PDLParseException {
        if (!this.includeKeyInfoSubject) {
            return false;
        }
        if (newLine) {
            parser.newLine(true);
        }
        parser.parseFragment((Reader)new StringReader(PACKAGE.Messages.getString("CertificateAppearanceCreator.label.subject", new Object[0])));
        this.parseDn(parser, this.keyInfo.getSubject());
        return true;
    }

    protected void parseDn(PDLAbstractDocumentParser parser, X500SimpleName dn) throws IOException, PDLParseException {
        for (String key : INFO_KEYS) {
            String value = dn.getByKey(key);
            if (StringTools.isEmpty((String)value)) continue;
            parser.newLine(true);
            parser.parseFragment((Reader)new StringReader(key + "=" + value));
        }
    }

    protected boolean parseHeader(PDLAbstractDocumentParser parser) throws IOException, PDLParseException {
        if (!this.includeSignerName) {
            return false;
        }
        String signerName = this.keyInfo.getSubject().getCommonName();
        if (signerName == null) {
            signerName = "";
        }
        parser.parseFragment((Reader)new StringReader(signerName));
        return true;
    }

    protected void parseText(PDLAbstractDocumentParser parser) throws IOException, PDLParseException {
        IPDLTextPad textPad = parser.getPad();
        float fontSize = this.getFontSize();
        if (fontSize == -1.0f) {
            fontSize = 10.0f;
        }
        PDLTextFormat textFormat = textPad.getTextFormat().copy();
        textFormat.setFontSize(fontSize * 1.2f);
        textPad.setTextFormat(textFormat);
        boolean hasContent = this.parseHeader(parser);
        parser.flush();
        textFormat = textPad.getTextFormat().copy();
        textFormat.setFontSize(fontSize);
        textPad.setTextFormat(textFormat);
        hasContent |= this.parseBodySubject(parser, hasContent);
        hasContent |= this.parseBodyIssuer(parser, hasContent);
        this.parseBodyDate(parser, hasContent);
        parser.close();
    }

    public void setIncludeDate(boolean includeDate) {
        this.includeDate = includeDate;
    }

    public void setIncludeKeyInfoIssuer(boolean includeKeyInfoIssuer) {
        this.includeKeyInfoIssuer = includeKeyInfoIssuer;
    }

    public void setIncludeKeyInfoSubject(boolean includeKeyInfoSubject) {
        this.includeKeyInfoSubject = includeKeyInfoSubject;
    }

    public void setIncludeSignerName(boolean includeSignerName) {
        this.includeSignerName = includeSignerName;
    }
}

