/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.license.ILicenseWithdrawal;
import de.intarsys.tools.license.LicenseAccount;
import de.intarsys.tools.license.LicenseProperty;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseWithdrawal
implements ILicenseWithdrawal {
    private static final Logger Log = LoggerFactory.getLogger(LicenseWithdrawal.class);
    private final LicenseAccount account;
    private final LicenseProperty property;
    private final LicensePropertyUnit unit;
    private final int amount;

    public LicenseWithdrawal(LicenseAccount account, LicenseProperty property, LicensePropertyUnit unit, int amount) {
        this.account = account;
        this.property = property;
        this.unit = unit;
        this.amount = amount;
    }

    @Override
    public void abort() {
        this.getUnit().deposit(this.getAccount(), this.getAmount());
    }

    @Override
    public void commit() {
        LicenseTools.publishWithdraw(this.getAccount(), this.property, this.amount);
        Log.info(this.getAccount().getWithdrawMessage(this.amount));
    }

    @Override
    public LicenseAccount getAccount() {
        return this.account;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    public LicenseProperty getProperty() {
        return this.property;
    }

    @Override
    public LicensePropertyUnit getUnit() {
        return this.unit;
    }
}

