/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.license.LicenseAccount;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseProperty;
import de.intarsys.tools.license.LicensePropertyUnit;

public class LicensePropertyUnitDefault
extends LicensePropertyUnit {
    @Override
    protected void deposit(LicenseAccount account, int amount) throws LicenseException {
        this.load(account);
        LicensePropertyUnitDefault.incrementSpentTokens(account, -amount);
        this.save(account);
    }

    @Override
    public String getId() {
        return "default";
    }

    @Override
    public String getLabel() {
        return "default unit";
    }

    @Override
    protected void withdraw(LicenseAccount account, LicenseProperty property, int amount) throws LicenseException {
        int maxTokens = this.getLimit(property, account);
        if (maxTokens >= 0 && LicensePropertyUnitDefault.getSpentTokens(account) >= maxTokens) {
            this.handleRestrictionExceeded(account, property, maxTokens, LicensePropertyUnitDefault.getSpentTokens(account));
        }
        LicensePropertyUnitDefault.incrementSpentTokens(account, amount);
    }
}

