/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.license.ILicenseWithdrawal;
import de.intarsys.tools.license.LicenseAccount;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseProperty;
import de.intarsys.tools.license.LicensePropertyUnitDeny;
import de.intarsys.tools.license.LicenseWithdrawal;
import de.intarsys.tools.license.PACKAGE;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.reporter.Reporter;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LicensePropertyUnit {
    private static final Attribute ATTR_LAST_SAVE = new Attribute("lastSave");
    private static final Attribute ATTR_SPENT_TOKENS = new Attribute("spentTokens");
    private static final Map<String, LicensePropertyUnit> units = new HashMap<String, LicensePropertyUnit>();
    public static final LicensePropertyUnit PER_MINUTE = LicensePropertyUnit.create("de.intarsys.tools.license.LicensePropertyUnitPerMinute");
    public static final LicensePropertyUnit PER_HOUR = LicensePropertyUnit.create("de.intarsys.tools.license.LicensePropertyUnitPerHour");
    public static final LicensePropertyUnit PER_DAY = LicensePropertyUnit.create("de.intarsys.tools.license.LicensePropertyUnitPerDay");
    public static final LicensePropertyUnit PER_WEEK = LicensePropertyUnit.create("de.intarsys.tools.license.LicensePropertyUnitPerWeek");
    public static final LicensePropertyUnit PER_MONTH = LicensePropertyUnit.create("de.intarsys.tools.license.LicensePropertyUnitPerMonth");
    public static final LicensePropertyUnit PER_YEAR = LicensePropertyUnit.create("de.intarsys.tools.license.LicensePropertyUnitPerYear");
    public static final LicensePropertyUnit PER_WORKUNIT = LicensePropertyUnit.create("de.intarsys.tools.license.LicensePropertyUnitPerWorkUnit");
    public static final LicensePropertyUnit PER_SESSION = LicensePropertyUnit.create("de.intarsys.tools.license.LicensePropertyUnitPerSession");
    public static final LicensePropertyUnit ABSOLUTE = LicensePropertyUnit.create("de.intarsys.tools.license.LicensePropertyUnitAbsolute");
    public static final LicensePropertyUnit DEFAULT = LicensePropertyUnit.create("de.intarsys.tools.license.LicensePropertyUnitDefault");
    private static final Logger Log = LoggerFactory.getLogger(LicensePropertyUnit.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;

    private static LicensePropertyUnit create(String name) {
        try {
            LicensePropertyUnit unit = (LicensePropertyUnit)Class.forName(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            LicensePropertyUnit.registerLicensePropertyUnit(unit);
            return unit;
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            Log.info("can't register license property unit " + name, (Throwable)exception);
            return new LicensePropertyUnitDeny(name);
        }
    }

    protected static long getLastSave(IAttributeSupport attributes) {
        long l;
        Object object = attributes.getAttribute((Object)ATTR_LAST_SAVE);
        if (object instanceof Number) {
            Number number = (Number)object;
            l = number.longValue();
        } else {
            l = 0L;
        }
        return l;
    }

    protected static int getSpentTokens(IAttributeSupport attributes) {
        int n;
        Object object = attributes.getAttribute((Object)ATTR_SPENT_TOKENS);
        if (object instanceof Number) {
            Number number = (Number)object;
            n = number.intValue();
        } else {
            n = 0;
        }
        return n;
    }

    public static final LicensePropertyUnit getUnit(String id) {
        LicensePropertyUnit unit = units.get(id);
        if (unit == null) {
            return new LicensePropertyUnitDeny(id);
        }
        return unit;
    }

    protected static synchronized void incrementSpentTokens(IAttributeSupport as, int value) {
        int current = LicensePropertyUnit.getSpentTokens(as);
        as.setAttribute((Object)ATTR_SPENT_TOKENS, (Object)(current + value));
    }

    public static void registerLicensePropertyUnit(LicensePropertyUnit unit) {
        if (units.get(unit.getId()) != null) {
            throw new IllegalArgumentException("can't re-register unit '" + unit.getId() + "'");
        }
        units.put(unit.getId(), unit);
    }

    protected static void setLastSave(IAttributeSupport as, long value) {
        as.setAttribute((Object)ATTR_LAST_SAVE, (Object)value);
    }

    protected static void setSpentTokens(IAttributeSupport as, int value) {
        as.setAttribute((Object)ATTR_SPENT_TOKENS, (Object)value);
    }

    public float convertFrom(LicensePropertyUnit to, float value) {
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delay(LicenseAccount account, int maxTokens, int delay) {
        String delayInfoUnit;
        if (delay <= 50) {
            return;
        }
        long delayInfo = delay;
        if (delay >= 86400000) {
            delayInfo = delay / 86400000;
            delayInfoUnit = Msg.getString("LicensePropertyUnit.DelayMessageUnit.days", new Object[0]);
        } else if (delay >= 3600000) {
            delayInfo = delay / 3600000;
            delayInfoUnit = Msg.getString("LicensePropertyUnit.DelayMessageUnit.h", new Object[0]);
        } else if (delay >= 60000) {
            delayInfo = delay / 60000;
            delayInfoUnit = Msg.getString("LicensePropertyUnit.DelayMessageUnit.min", new Object[0]);
        } else if (delay >= 1000) {
            delayInfo = delay / 1000;
            delayInfoUnit = Msg.getString("LicensePropertyUnit.DelayMessageUnit.s", new Object[0]);
        } else {
            delayInfoUnit = Msg.getString("LicensePropertyUnit.DelayMessageUnit.ms", new Object[0]);
        }
        Log.info("license restriction, delay {}", (Object)delay);
        IMessage msg = Msg.getMessage("LicensePropertyUnit.DelayMessage", new Object[]{delayInfo, delayInfoUnit});
        IProgressMonitor monitor = Reporter.get().reportActivityStart(msg, 1);
        try {
            ThreadTools.sleep((long)delay);
        }
        finally {
            monitor.end();
        }
    }

    protected abstract void deposit(LicenseAccount var1, int var2) throws LicenseException;

    protected int getBalance(LicenseProperty property, LicenseAccount account) {
        this.load(account);
        int limit = this.getLimit(property, account);
        if (limit < 0) {
            return -1;
        }
        return Math.max(0, limit - LicensePropertyUnit.getSpentTokens(account));
    }

    public float getCanonicalValue(float value) {
        return value;
    }

    protected String getExceededMessage(LicenseAccount account, int maxTokens) {
        return Msg.getString("LicensePropertyUnit.Exceeded", new Object[]{account.getLicenseProduct().getId(), account.getPropertyName(), maxTokens, this.getLabel()});
    }

    public abstract String getId();

    public abstract String getLabel();

    protected int getLimit(LicenseProperty property, LicenseAccount account) {
        return property.getValueInt();
    }

    public Instant getNextReset(LicenseAccount account) {
        return null;
    }

    protected void handleRestrictionExceeded(LicenseAccount account, LicenseProperty property, int maxTokens, float spentTokens) throws LicenseException {
        String message = this.getExceededMessage(account, maxTokens);
        Log.warn(message);
        Reporter.get().reportStatus(message, 2);
        String onExceededOption = property.getOption("onExceeded");
        if (onExceededOption == null) {
            this.handleRestrictionExceededDefault(account, maxTokens, spentTokens);
        } else {
            if ("fail".equals(onExceededOption)) {
                throw new LicenseException(this.getExceededMessage(account, maxTokens));
            }
            try {
                int delay = Integer.parseInt(onExceededOption);
                this.delay(account, maxTokens, delay);
            }
            catch (NumberFormatException e) {
                this.handleRestrictionExceededDefault(account, maxTokens, spentTokens);
            }
        }
    }

    protected void handleRestrictionExceededDefault(LicenseAccount account, int maxTokens, float spentTokens) throws LicenseException {
        throw new LicenseException(this.getExceededMessage(account, maxTokens));
    }

    protected void load(LicenseAccount account) {
        account.load(this);
    }

    protected void load(LicenseAccount account, IPreferences propertyNode) {
        LicensePropertyUnit.setLastSave(account, propertyNode.getLong("lastSave"));
        LicensePropertyUnit.setSpentTokens(account, propertyNode.getInt("spentTokens"));
    }

    protected ILicenseWithdrawal reserve(LicenseAccount account, LicenseProperty property, int amount) throws LicenseException {
        this.withdraw(account, property, amount);
        return new LicenseWithdrawal(account, property, this, amount);
    }

    protected void save(LicenseAccount account) {
        account.save(this);
    }

    protected void save(LicenseAccount account, IPreferences propertyNode) {
        propertyNode.put("lastSave", LicensePropertyUnit.getLastSave(account));
        propertyNode.put("spentTokens", LicensePropertyUnit.getSpentTokens(account));
    }

    protected abstract void withdraw(LicenseAccount var1, LicenseProperty var2, int var3) throws LicenseException;
}

