/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.collection.FilterIterator;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.license.EnumLicenseState;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicenseProperty;
import de.intarsys.tools.license.PACKAGE;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class License {
    protected static final License NA = new License();
    private static final IMessageBundle Msg;
    public static final String TYPE_TEST = "test";
    public static final String TYPE_FULL = "full";
    protected static final String AUTH_SUCCESS = "success";
    protected static final String AUTH_NONE = "none";
    protected static final String AUTH_FAILED = "failed";
    private static MessageDigest MD;
    private static final DateTimeFormatter DATEFORMATTER;
    public static final String PROPERTY_ID = "id";
    private static final Logger Log;
    private String productId;
    private String productVersion;
    private String type;
    private LocalDateTime validFrom;
    private LocalDateTime validTo;
    private final int licenseVersion = 0;
    private final List<LicenseProperty> properties = new ArrayList<LicenseProperty>();
    private String ownerKey;
    private int quantity = 1;
    private byte[] key;
    private String authentication = null;
    private ILocator locator;

    public static final DateTimeFormatter getDateFormatter() {
        return new DateTimeFormatterBuilder().appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('/').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('/').appendValue(ChronoField.YEAR, 4).toFormatter();
    }

    protected static int getMajorVersion(String versionString) {
        if (versionString == null) {
            return -1;
        }
        String[] segments = versionString.split("\\.", 2);
        try {
            return Integer.parseInt(segments[0]);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static MessageDigest getMD() throws LicenseException {
        if (MD == null) {
            try {
                MD = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new LicenseException("message digest unavailable");
            }
        }
        return MD;
    }

    protected void addProperty(LicenseProperty property) {
        this.properties.add(property);
        this.authentication = null;
    }

    protected void authenticate() throws LicenseException {
        byte[] newHash = this.createHash();
        byte[] currentHash = this.decryptKey();
        this.authentication = !Arrays.equals(currentHash, newHash) ? AUTH_FAILED : AUTH_SUCCESS;
        Log.info("{} authentication {}", (Object)this, (Object)this.authentication);
    }

    protected void basicSetProperty(String name, String value, String options, boolean generic) {
        LicenseProperty property = LicenseProperty.create(this, name, value, options, generic);
        this.addProperty(property);
    }

    public int compareTo(Object o) {
        License other = (License)o;
        if (other.isValidPeriod()) {
            if (!this.isValidPeriod()) {
                return -1;
            }
        } else if (this.isValidPeriod()) {
            return 1;
        }
        if (other.isTypeFull()) {
            if (License.getMajorVersion(other.getProductVersion()) > License.getMajorVersion(this.getProductVersion())) {
                return -1;
            }
            return 1;
        }
        return 1;
    }

    public byte[] createHash() throws LicenseException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProductId());
        sb.append(";");
        sb.append(this.getProductVersion());
        sb.append(";");
        sb.append(this.getType());
        sb.append(";");
        sb.append(this.getValidFromString());
        sb.append(";");
        sb.append(this.getValidToString());
        sb.append(";");
        sb.append(this.getQuantity());
        sb.append(";");
        sb.append(this.getOwnerKey());
        sb.append(";");
        for (LicenseProperty property : this.properties) {
            if (!property.isGeneric()) continue;
            sb.append(property.getNameValueUnitString());
            sb.append(";");
        }
        return this.createHash(StringTools.toByteArray((String)sb.toString()));
    }

    protected synchronized byte[] createHash(byte[] data) throws LicenseException {
        MessageDigest md = License.getMD();
        md.reset();
        md.update(data);
        return md.digest();
    }

    protected byte[] decryptKey() throws LicenseException {
        return LicenseEnvironment.get().decrypt(this.getKey());
    }

    public boolean equals(Object other) {
        if (!(other instanceof License)) {
            return false;
        }
        License otherLicense = (License)other;
        if (!this.productId.equals(otherLicense.productId)) {
            return false;
        }
        if (!this.productVersion.equals(otherLicense.productVersion)) {
            return false;
        }
        if (!this.type.equals(otherLicense.type)) {
            return false;
        }
        if (this.validFrom == null && otherLicense.validFrom != null) {
            return false;
        }
        if (this.validFrom != null && !this.validFrom.equals(otherLicense.validFrom)) {
            return false;
        }
        if (this.validTo == null && otherLicense.validTo != null) {
            return false;
        }
        if (this.validTo != null && !this.validTo.equals(otherLicense.validTo)) {
            return false;
        }
        if (this.quantity != otherLicense.quantity) {
            return false;
        }
        if (!this.ownerKey.equals(otherLicense.ownerKey)) {
            return false;
        }
        if (this.properties.size() != otherLicense.properties.size()) {
            return false;
        }
        Iterator<LicenseProperty> itThis = this.properties.iterator();
        Iterator<LicenseProperty> itOther = otherLicense.properties.iterator();
        while (itThis.hasNext()) {
            LicenseProperty otherProp;
            LicenseProperty thisProp = itThis.next();
            if (thisProp.equals(otherProp = itOther.next())) continue;
            return false;
        }
        return true;
    }

    public byte[] getKey() {
        return this.key;
    }

    public String getKeyString() {
        byte[] keyBase = this.getKey();
        if (keyBase == null) {
            return "";
        }
        return StringTools.toString((byte[])Base64.encode((byte[])keyBase));
    }

    public int getLicenseVersion() {
        return 0;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public String getOwnerKey() {
        return this.ownerKey;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getProductVersionString() {
        return String.valueOf(this.productVersion);
    }

    public Iterator<LicenseProperty> getProperties() {
        return this.properties.iterator();
    }

    public Iterator<LicenseProperty> getProperties(final String name) {
        return new FilterIterator<LicenseProperty>(this.properties.iterator()){

            protected boolean accept(LicenseProperty object) {
                return object.getName().equals(name);
            }
        };
    }

    public String getPropertiesString() {
        StringBuilder sb = new StringBuilder();
        for (LicenseProperty property : this.properties) {
            sb.append(property.getNameValueUnitString());
            String tempOptionString = property.getOptionsString();
            if (!StringTools.isEmpty((String)tempOptionString)) {
                sb.append("|");
                sb.append(tempOptionString);
            }
            sb.append("; ");
        }
        return sb.toString();
    }

    public LicenseProperty getProperty(String name) {
        Iterator<LicenseProperty> it = this.getProperties(name);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public String getPropertyValue(String name) {
        LicenseProperty property = this.getProperty(name);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    public List<String> getPropertyValues(String name) {
        ArrayList<String> result = new ArrayList<String>();
        for (LicenseProperty property : this.properties) {
            if (!property.getName().equals(name)) continue;
            result.add(property.getValue());
        }
        return result;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public String getQuantityString() {
        return String.valueOf(this.getQuantity());
    }

    public EnumLicenseState getState(LicenseProduct target) {
        if (this == NA || target == null || !target.getId().equals(this.getProductId())) {
            return EnumLicenseState.NA;
        }
        if (!this.isValidPeriod()) {
            return EnumLicenseState.INVALID;
        }
        EnumLicenseState result = this.isTypeFull() ? EnumLicenseState.VALID : EnumLicenseState.TEST;
        String version = target.getVersion();
        int targetMajor = License.getMajorVersion(version);
        if (targetMajor == -1) {
            return EnumLicenseState.INVALID;
        }
        int licenseMajor = License.getMajorVersion(this.getProductVersion());
        if (targetMajor <= licenseMajor) {
            return result;
        }
        return EnumLicenseState.INVALID;
    }

    public String getStateString(LicenseProduct target) {
        StringBuilder sb = new StringBuilder();
        if (this.isTypeTest()) {
            sb.append(Msg.getString("License.InfoTestLicense", new Object[0]));
        } else {
            sb.append(Msg.getString("License.InfoFullLicense", new Object[0]));
        }
        try {
            EnumLicenseState state = this.getState(target);
            if (state == EnumLicenseState.NA) {
                if (this.isValidSignature() && target == LicenseProduct.NA) {
                    sb.append(", " + Msg.getString("License.InfoNotLoaded", new Object[0]));
                } else {
                    sb.append(", " + Msg.getString("License.InfoNotValid", new Object[0]));
                }
            } else if (state != EnumLicenseState.INVALID) {
                if (this.getValidTo() != null) {
                    sb.append(", " + Msg.getString("License.InfoValidUntil", new Object[0]) + " ");
                    sb.append(this.getValidToString());
                } else {
                    sb.append(", " + Msg.getString("License.InfoNoTimeLimit", new Object[0]));
                }
            } else if (this.isValidSignature()) {
                sb.append(", " + Msg.getString("License.InfoNoLongerValid", new Object[0]));
            } else {
                sb.append(", " + Msg.getString("License.InfoNotValid", new Object[0]));
            }
        }
        catch (LicenseException e) {
            sb.append(", " + Msg.getString("License.InfoAuthenticationException", new Object[0]));
        }
        return sb.toString();
    }

    public String getType() {
        return this.type;
    }

    public LocalDateTime getValidFrom() {
        return this.validFrom;
    }

    public synchronized String getValidFromString() {
        if (this.getValidFrom() == null) {
            return "";
        }
        return DATEFORMATTER.format(this.getValidFrom());
    }

    public LocalDateTime getValidTo() {
        return this.validTo;
    }

    public synchronized String getValidToString() {
        if (this.getValidTo() == null) {
            return "";
        }
        return DATEFORMATTER.format(this.getValidTo());
    }

    public int hashCode() {
        return this.productId.hashCode();
    }

    public boolean isDefined() {
        return this != NA;
    }

    protected boolean isTypeFull() {
        return this.type != null && this.type.equals(TYPE_FULL);
    }

    protected boolean isTypeTest() {
        return this.type != null && this.type.equals(TYPE_TEST);
    }

    public boolean isValidPeriod() {
        if (!this.isValidSignature()) {
            return false;
        }
        LocalDateTime today = LocalDateTime.ofInstant(DateEnvironment.get().now().toInstant(), ZoneId.systemDefault());
        return !(this.validFrom != null && this.validFrom.compareTo(today) > 0 || this.validTo != null && this.validTo.compareTo(today) < 0);
    }

    public synchronized boolean isValidSignature() {
        try {
            if (this.authentication == null) {
                this.authenticate();
            }
            return this.authentication == AUTH_SUCCESS;
        }
        catch (LicenseException e) {
            this.authentication = AUTH_FAILED;
            return false;
        }
    }

    public void removeProperty(String name) {
        Iterator<LicenseProperty> it = this.properties.iterator();
        while (it.hasNext()) {
            LicenseProperty property = it.next();
            if (!property.getName().equals(name)) continue;
            it.remove();
        }
        this.authentication = null;
    }

    public synchronized void reset() {
        this.authentication = null;
    }

    public void setKey(byte[] key) {
        this.key = key;
        this.authentication = null;
    }

    public void setKeyString(String keyString) {
        if (keyString == null || keyString.length() == 0) {
            this.setKey(null);
        } else {
            try {
                this.setKey(Base64.decode((String)keyString));
            }
            catch (IOException e) {
                Log.warn("can not decode license key");
            }
        }
    }

    public void setLocator(ILocator locator) {
        this.locator = locator;
    }

    public void setOwnerKey(String key) {
        this.ownerKey = null == key ? "" : key;
        this.authentication = null;
    }

    public void setProductId(String productId) {
        this.productId = productId;
        this.basicSetProperty(PROPERTY_ID, productId, null, false);
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
        this.authentication = null;
    }

    public void setProperty(String name, String value) {
        LicenseProperty property = LicenseProperty.create(this, name, value, true);
        this.addProperty(property);
    }

    public void setProperty(String name, String value, String options) {
        this.basicSetProperty(name, value, options, true);
    }

    public void setQuantity(int pQuantity) {
        if (pQuantity < 1) {
            pQuantity = 1;
        }
        this.quantity = pQuantity;
        this.authentication = null;
    }

    public void setQuantityString(String quantityString) {
        try {
            this.setQuantity(Integer.parseInt(quantityString));
        }
        catch (NumberFormatException e) {
            this.setQuantity(1);
        }
    }

    public void setType(String type) {
        this.type = type;
        this.authentication = null;
    }

    public void setValidFrom(LocalDate validFromDate) {
        this.validFrom = validFromDate == null ? null : LocalDateTime.of(validFromDate, LocalTime.of(0, 0, 0));
        this.authentication = null;
    }

    public synchronized void setValidFromString(String dateString) throws ParseException {
        if (dateString == null || dateString.length() == 0) {
            return;
        }
        this.setValidFrom(LocalDate.parse(dateString, DATEFORMATTER));
    }

    public void setValidTo(LocalDate validToDate) {
        this.validTo = validToDate == null ? null : LocalDateTime.of(validToDate, LocalTime.of(23, 59, 59));
        this.authentication = null;
    }

    public synchronized void setValidToString(String dateString) throws ParseException {
        if (dateString == null || dateString.length() == 0) {
            return;
        }
        this.setValidTo(LocalDate.parse(dateString, DATEFORMATTER));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProductId());
        sb.append("; ");
        sb.append(this.getProductVersionString());
        sb.append("; ");
        sb.append(this.getOwnerKey());
        sb.append("; ");
        sb.append(this.getValidFromString());
        sb.append("; ");
        sb.append(this.getValidToString());
        sb.append("; ");
        sb.append(this.getPropertiesString());
        return sb.toString();
    }

    static {
        NA.setProductId("de.intarsys.license.unavailable");
        NA.addProperty(LicenseProperty.NA);
        Msg = PACKAGE.Messages;
        DATEFORMATTER = License.getDateFormatter();
        Log = LoggerFactory.getLogger(License.class);
    }
}

