/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.quantity;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import tec.units.ri.format.QuantityFormat;
import tec.units.ri.quantity.DoubleQuantity;
import tec.units.ri.quantity.FloatQuantity;
import tec.units.ri.quantity.IntegerQuantity;
import tec.units.ri.quantity.LongQuantity;
import tec.units.ri.quantity.NumberQuantity;
import tec.units.ri.quantity.ShortQuantity;

public final class Quantities {
    private Quantities() {
    }

    public static Quantity<?> getQuantity(CharSequence csq) {
        try {
            return (Quantity)QuantityFormat.getInstance().parse(csq);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ParserException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <Q extends Quantity<Q>> Quantity<Q> getQuantity(Number value, Unit<Q> unit) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (unit == null) {
            throw new NullPointerException();
        }
        if (Double.class.isInstance(value)) {
            return new DoubleQuantity<Q>(value.doubleValue(), unit);
        }
        if (Long.class.isInstance(value)) {
            return new LongQuantity<Q>((Long)Long.class.cast(value), unit);
        }
        if (Short.class.isInstance(value)) {
            return new ShortQuantity<Q>((Short)Short.class.cast(value), unit);
        }
        if (Integer.class.isInstance(value)) {
            return new IntegerQuantity<Q>((Integer)Integer.class.cast(value), unit);
        }
        if (Float.class.isInstance(value)) {
            return new FloatQuantity<Q>(((Float)Float.class.cast(value)).floatValue(), unit);
        }
        return new NumberQuantity<Q>(value, unit);
    }
}

