/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.format;

import java.io.IOException;
import javax.measure.MeasurementException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import tec.units.ri.AbstractQuantity;
import tec.units.ri.AbstractUnit;
import tec.units.ri.format.SimpleUnitFormat;
import tec.units.ri.quantity.NumberQuantity;
import tec.uom.lib.common.function.Parser;

public abstract class QuantityFormat
implements Parser<CharSequence, Quantity> {
    private static final QuantityFormat DEFAULT = new Standard();

    public static QuantityFormat getInstance() {
        return DEFAULT;
    }

    public abstract Appendable format(Quantity<?> var1, Appendable var2) throws IOException;

    abstract Quantity<?> parse(CharSequence var1, int var2) throws IllegalArgumentException, ParserException;

    public final StringBuilder format(Quantity<?> q, StringBuilder dest) {
        try {
            return (StringBuilder)this.format(q, (Appendable)dest);
        }
        catch (IOException ex) {
            throw new MeasurementException((Throwable)ex);
        }
    }

    public final String format(Quantity q) {
        if (q instanceof AbstractQuantity) {
            return this.format((AbstractQuantity)q, new StringBuilder()).toString();
        }
        return this.format(q, new StringBuilder()).toString();
    }

    static int getFractionDigitsCount(double d) {
        if (d >= 1.0) {
            d -= (double)((long)d);
        }
        if (d == 0.0) {
            return 0;
        }
        d *= 10.0;
        int count = 1;
        while (d - (double)((long)d) != 0.0) {
            d *= 10.0;
            ++count;
        }
        return count;
    }

    private static final class Standard
    extends QuantityFormat {
        private Standard() {
        }

        public Appendable format(Quantity q, Appendable dest) throws IOException {
            Unit unit = q.getUnit();
            Number number = q.getValue();
            dest.append(number.toString());
            if (q.getUnit().equals(AbstractUnit.ONE)) {
                return dest;
            }
            dest.append(' ');
            return SimpleUnitFormat.getInstance().format(unit, dest);
        }

        @Override
        Quantity<?> parse(CharSequence csq, int index) throws ParserException {
            int endDecimal;
            int startDecimal;
            for (startDecimal = index; startDecimal < csq.length() && Character.isWhitespace(csq.charAt(startDecimal)); ++startDecimal) {
            }
            for (endDecimal = startDecimal + 1; endDecimal < csq.length() && !Character.isWhitespace(csq.charAt(endDecimal)); ++endDecimal) {
            }
            Double decimal = new Double(csq.subSequence(startDecimal, endDecimal).toString());
            int startUnit = endDecimal + 1;
            Unit<?> unit = SimpleUnitFormat.getInstance().parse(csq, startUnit);
            return NumberQuantity.of(decimal, unit);
        }

        public Quantity<?> parse(CharSequence csq) throws ParserException {
            return this.parse(csq, 0);
        }
    }
}

