/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.aaa.authenticate.impl;

import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.aaa.authenticate.api.ICredentialScope;
import de.intarsys.aaa.authenticate.api.ICredentialStore;
import de.intarsys.aaa.authenticate.impl.BasicCredentialProvider;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.function.Predicate;

public class FilteredCredentialStore
implements ICredentialStore,
IElementConfigurable {
    private static final String TAG_PREDICATE = "predicate";
    private Predicate<ICredentialScope> predicate;
    private ICredentialStore store = new BasicCredentialProvider();

    public FilteredCredentialStore() {
        this(new TruePredicate());
    }

    public FilteredCredentialStore(Predicate<ICredentialScope> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean acceptCredentialScope(ICredentialScope scope) {
        return this.store.acceptCredentialScope(scope);
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    public void configure(IElement element) throws ConfigurationException {
        IElement predicateElement = element.element(TAG_PREDICATE);
        if (predicateElement != null) {
            try {
                this.predicate = (Predicate)ElementTools.createObject((IElement)predicateElement, Predicate.class, null, (IArgs)Args.create());
            }
            catch (ObjectCreationException ex) {
                throw new ConfigurationException((Throwable)ex);
            }
        }
    }

    @Override
    public ICredential getCredential(ICredentialScope scope) {
        if (this.predicate.test(scope)) {
            return this.store.getCredential(scope);
        }
        return null;
    }

    public Predicate<ICredentialScope> getPredicate() {
        return this.predicate;
    }

    @Override
    public void removeCredential(ICredentialScope scope) {
        if (this.predicate.test(scope)) {
            this.store.removeCredential(scope);
        }
    }

    @Override
    public void setCredential(ICredentialScope scope, ICredential credential) {
        if (this.predicate.test(scope)) {
            this.store.setCredential(scope, credential);
        }
    }

    public void setPredicate(Predicate<ICredentialScope> predicate) {
        this.predicate = predicate;
    }

    private static class TruePredicate
    implements Predicate<ICredentialScope> {
        private TruePredicate() {
        }

        @Override
        public boolean test(ICredentialScope scope) {
            return true;
        }
    }
}

