/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jaxrs.logging;

import de.intarsys.tools.jaxrs.logging.ClientLoggingFilter;
import de.intarsys.tools.jaxrs.logging.ServerLoggingFilter;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class LoggingFeature
implements Feature {
    public static final String DEFAULT_LOGGER_NAME = LoggingFeature.class.getName();
    public static final Level DEFAULT_LOGGER_LEVEL = Level.DEBUG;
    public static final int DEFAULT_MAX_ENTITY_SIZE = 8192;
    public static final Verbosity DEFAULT_VERBOSITY = Verbosity.PAYLOAD_TEXT;
    private final Logger filterLogger;
    private final Verbosity verbosity;
    private final Integer maxEntitySize;
    private final Level level;

    public LoggingFeature() {
        this(null, null, null, null);
    }

    public LoggingFeature(Logger logger) {
        this(logger, null, null, null);
    }

    public LoggingFeature(Logger logger, Integer maxEntitySize) {
        this(logger, null, DEFAULT_VERBOSITY, maxEntitySize);
    }

    public LoggingFeature(Logger logger, Level level, Verbosity verbosity, Integer maxEntitySize) {
        this.filterLogger = logger;
        this.level = level;
        this.verbosity = verbosity;
        this.maxEntitySize = maxEntitySize;
    }

    public LoggingFeature(Logger logger, Verbosity verbosity) {
        this(logger, null, verbosity, null);
    }

    public boolean configure(FeatureContext context) {
        if (context.getConfiguration().getRuntimeType() == RuntimeType.CLIENT) {
            ClientLoggingFilter clientLoggingFilter = new ClientLoggingFilter(this.filterLogger != null ? this.filterLogger : LoggerFactory.getLogger((String)DEFAULT_LOGGER_NAME), this.level != null ? this.level : DEFAULT_LOGGER_LEVEL, this.verbosity != null ? this.verbosity : DEFAULT_VERBOSITY, this.maxEntitySize != null ? this.maxEntitySize : 8192);
            context.register((Object)clientLoggingFilter);
            return true;
        }
        if (context.getConfiguration().getRuntimeType() == RuntimeType.SERVER) {
            ServerLoggingFilter serverClientFilter = new ServerLoggingFilter(this.filterLogger != null ? this.filterLogger : LoggerFactory.getLogger((String)DEFAULT_LOGGER_NAME), this.level != null ? this.level : DEFAULT_LOGGER_LEVEL, this.verbosity != null ? this.verbosity : DEFAULT_VERBOSITY, this.maxEntitySize != null ? this.maxEntitySize : 8192);
            context.register((Object)serverClientFilter);
            return true;
        }
        return false;
    }

    public static enum Verbosity {
        HEADERS_ONLY,
        PAYLOAD_TEXT,
        PAYLOAD_ANY;

    }
}

