/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jaxrs.filter;

import de.intarsys.tools.string.StringTools;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import java.io.IOException;

public class CorsFilter
implements ContainerResponseFilter {
    private static final String HDR_ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    private static final String HDR_ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String HDR_ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private static final String HDR_ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String HDR_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private boolean global;
    private String allowOrigin;

    public CorsFilter() {
        this.global = false;
        this.allowOrigin = null;
    }

    public CorsFilter(boolean global) {
        this.global = global;
        this.allowOrigin = null;
    }

    public CorsFilter(String allowOrigin) {
        this.global = false;
        this.allowOrigin = allowOrigin;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (this.responseHasCors(responseContext)) {
            return;
        }
        if (this.global) {
            responseContext.getHeaders().add((Object)HDR_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)requestContext.getHeaderString("origin"));
        } else if (!StringTools.isEmpty((String)this.getAllowOrigin())) {
            responseContext.getHeaders().add((Object)HDR_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)this.getAllowOrigin());
        } else {
            return;
        }
        responseContext.getHeaders().add((Object)HDR_ACCESS_CONTROL_ALLOW_HEADERS, (Object)"*");
        responseContext.getHeaders().add((Object)HDR_ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
        responseContext.getHeaders().add((Object)HDR_ACCESS_CONTROL_ALLOW_METHODS, (Object)"*");
        responseContext.getHeaders().add((Object)HDR_ACCESS_CONTROL_EXPOSE_HEADERS, (Object)"Content-Type, Content-Disposition");
    }

    public String getAllowOrigin() {
        return this.allowOrigin;
    }

    public boolean isGlobal() {
        return this.global;
    }

    private boolean responseHasCors(ContainerResponseContext responseContext) {
        try {
            return responseContext.getHeaderString(HDR_ACCESS_CONTROL_ALLOW_ORIGIN) != null;
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public void setAllowOrigin(String allowOrigin) {
        this.allowOrigin = allowOrigin;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }
}

