/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jaxrs.exception;

import com.fasterxml.jackson.databind.JsonMappingException;
import de.intarsys.tools.converter.IConverter;
import de.intarsys.tools.exception.ErrorObject;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ErrorObjectFromJsonMappingExceptionConverter
implements IConverter<JsonMappingException, ErrorObject> {
    private static final Pattern QUALIFIED_NAME_PATTERN = Pattern.compile("\\b(?:[_a-zA-Z][_a-zA-Z0-9]*+[.$])*+(?<simpleName>[_a-zA-Z][_a-zA-Z0-9]*+)\\b");
    private static final String SIMPLE_NAME_REPLACEMENT = "${simpleName}";

    public Class<?> getSourceType() {
        return JsonMappingException.class;
    }

    public Class<?> getTargetType() {
        return ErrorObject.class;
    }

    public ErrorObject convert(JsonMappingException exception) {
        String message = String.format("%s (through reference chain: %s)", this.stripQualifiedNames(exception.getOriginalMessage()), this.describe(exception.getPath()));
        return new ErrorObject("JsonMappingError", message, 400);
    }

    private String stripQualifiedNames(String message) {
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = QUALIFIED_NAME_PATTERN.matcher(message);
        while (matcher.find()) {
            matcher.appendReplacement(buffer, SIMPLE_NAME_REPLACEMENT);
        }
        return matcher.appendTail(buffer).toString();
    }

    private String describe(Collection<JsonMappingException.Reference> path) {
        return path.stream().map(this::describe).collect(Collectors.joining("->"));
    }

    private String describe(JsonMappingException.Reference reference) {
        StringBuilder description = new StringBuilder();
        Object from = reference.getFrom();
        if (from == null) {
            description.append("UNKNOWN");
        } else {
            Class<?> type = from instanceof Class ? (Class<?>)from : from.getClass();
            int dimensions = 0;
            while (type.isArray()) {
                type = type.getComponentType();
                ++dimensions;
            }
            description.append(type.getSimpleName());
            for (int i = 0; i < dimensions; ++i) {
                description.append("[]");
            }
        }
        description.append('[');
        String fieldName = reference.getFieldName();
        if (fieldName != null) {
            description.append('\"').append(fieldName).append('\"');
        } else {
            int index = reference.getIndex();
            if (index >= 0) {
                description.append(index);
            } else {
                description.append('?');
            }
        }
        return description.append(']').toString();
    }
}

