/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.standard;

import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.crypto.api.IByteStreamProvider;
import de.intarsys.tools.crypto.api.ICipherFactory;
import de.intarsys.tools.crypto.api.ICipherParameter;
import de.intarsys.tools.crypto.bytes.RandomByteProvider;
import de.intarsys.tools.crypto.bytes.StaticByteProvider;
import de.intarsys.tools.crypto.standard.CTREncryptedRandomAccess;
import de.intarsys.tools.crypto.standard.SecretKeyParameter;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.locator.AbstractLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.BufferedRandomAccess;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;

public class EncryptedLocator
extends AbstractLocator {
    private static final IByteStreamProvider BYTE_PROVIDER = new RandomByteProvider();
    private final ILocator locator;
    private final ICipherFactory cipherFactory;
    private final IByteProvider keyProvider;
    private final IByteProvider ivProvider;

    public EncryptedLocator(ILocator locator, ICipherFactory cipherFactory) throws IOException {
        this.locator = locator;
        this.cipherFactory = cipherFactory;
        this.ivProvider = new StaticByteProvider(BYTE_PROVIDER.getBytes(cipherFactory.getBlockSize()));
        this.keyProvider = new StaticByteProvider(BYTE_PROVIDER.getBytes(cipherFactory.getKeySize()));
    }

    protected ICipherParameter createCipherParameter() throws IOException {
        return new SecretKeyParameter(this.ivProvider.getBytes(), this.keyProvider.getBytes());
    }

    protected Cipher createDecipher() throws IOException, GeneralSecurityException {
        ICipherParameter cipherParameter = this.createCipherParameter();
        return this.getCipherFactory().createDecipher(cipherParameter);
    }

    protected Cipher createEncipher() throws IOException, GeneralSecurityException {
        ICipherParameter cipherParameter = this.createCipherParameter();
        return this.getCipherFactory().createEncipher(cipherParameter);
    }

    public void delete() throws IOException {
        this.getLocator().delete();
    }

    public boolean exists() {
        return this.getLocator().exists();
    }

    protected byte[] getBytes() throws IOException {
        return StreamTools.getBytes((InputStream)this.getInputStream());
    }

    public ILocator getChild(String name) {
        return this.wrap(this.getLocator().getChild(name));
    }

    public ICipherFactory getCipherFactory() {
        return this.cipherFactory;
    }

    public InputStream getInputStream() throws IOException {
        try {
            Cipher cipher = this.createDecipher();
            return new CipherInputStream(this.getLocator().getInputStream(), cipher);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("decryption initialization failed", e);
        }
    }

    protected IByteProvider getIvProvider() {
        return this.ivProvider;
    }

    protected IByteProvider getKeyProvider() {
        return this.keyProvider;
    }

    public long getLength() throws IOException {
        return this.getLocator().getLength();
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public String getName() {
        return this.getLocator().getName();
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            Cipher cipher = this.createEncipher();
            return new CipherOutputStream(this.getLocator().getOutputStream(), cipher);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("encryption initialization failed", e);
        }
    }

    public ILocator getParent() {
        return this.wrap(this.getLocator().getParent());
    }

    public String getPath() {
        return this.getLocator().getPath();
    }

    public IRandomAccess getRandomAccess() throws IOException {
        return new BufferedRandomAccess((IRandomAccess)new CTREncryptedRandomAccess(this.getLocator().getRandomAccess(), this.getCipherFactory(), this.getIvProvider(), this.getKeyProvider()));
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    public Reader getReader(String charset) throws IOException {
        if (StringTools.isEmpty((String)charset)) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), charset);
    }

    public Writer getWriter() throws IOException {
        return new OutputStreamWriter(this.getOutputStream());
    }

    public Writer getWriter(String charset) throws IOException {
        if (StringTools.isEmpty((String)charset)) {
            return this.getWriter();
        }
        return new OutputStreamWriter(this.getOutputStream(), charset);
    }

    public boolean isDirectory() {
        return this.getLocator().isDirectory();
    }

    public boolean isOutOfSynch() {
        return false;
    }

    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        ILocator[] children = this.getLocator().listLocators(filter);
        ArrayList<ILocator> result = new ArrayList<ILocator>();
        for (ILocator child : children) {
            if (filter != null && !filter.accept((ILocator)this, child.getName())) continue;
            String childPath = PathTools.join((String[])new String[]{this.getPath(), child.getName()});
            result.add(this.wrap(child));
        }
        return result.toArray(new ILocator[result.size()]);
    }

    public void rename(String newName) throws IOException {
        this.getLocator().rename(newName);
    }

    public void synch() {
    }

    public URI toURI() {
        return this.getLocator().toURI();
    }

    protected ILocator wrap(ILocator pLocator) {
        return pLocator;
    }
}

