/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.standard;

import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.crypto.api.IByteStreamProvider;
import de.intarsys.tools.crypto.api.ICipherFactory;
import de.intarsys.tools.crypto.api.ICipherParameter;
import de.intarsys.tools.crypto.bytes.RandomByteProvider;
import de.intarsys.tools.crypto.bytes.StaticByteProvider;
import de.intarsys.tools.crypto.standard.SecretKeyParameter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessFilter;
import de.intarsys.tools.randomaccess.RandomAccessInputStream;
import de.intarsys.tools.randomaccess.RandomAccessOutputStream;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;

public class CTREncryptedRandomAccess
extends RandomAccessFilter {
    private static final IByteStreamProvider BYTE_PROVIDER = new RandomByteProvider();
    private final ICipherFactory cipherFactory;
    private final IByteProvider keyProvider;
    private final IByteProvider ivProvider;
    private long localOffset;
    private final byte[] ivBytes;
    private final int blockSize;
    private Cipher encipher;
    private OutputStream randomOutputStream;
    private OutputStream cipherOutputStream;
    private long localWritePosition;
    private HideOutputStream hideOutputStream;

    public CTREncryptedRandomAccess(IRandomAccess random, ICipherFactory cipherFactory) throws IOException {
        this(random, cipherFactory, new StaticByteProvider(BYTE_PROVIDER.getBytes(cipherFactory.getBlockSize())), new StaticByteProvider(BYTE_PROVIDER.getBytes(cipherFactory.getKeySize())));
    }

    public CTREncryptedRandomAccess(IRandomAccess random, ICipherFactory cipherFactory, IByteProvider ivProvider, IByteProvider keyProvider) throws IOException {
        super(random);
        this.cipherFactory = cipherFactory;
        this.ivProvider = ivProvider;
        this.keyProvider = keyProvider;
        this.blockSize = cipherFactory.getBlockSize();
        this.ivBytes = new byte[this.blockSize];
    }

    public void close() throws IOException {
        this.writeFinalize();
        super.close();
    }

    protected ICipherParameter createCipherParameter(byte[] iv) throws IOException {
        return new SecretKeyParameter(iv, this.keyProvider.getBytes());
    }

    protected Cipher createDecipher(ICipherParameter cipherParameter) throws IOException, GeneralSecurityException {
        return this.getCipherFactory().createDecipher(cipherParameter);
    }

    protected Cipher createEncipher(ICipherParameter cipherParameter) throws IOException, GeneralSecurityException {
        return this.getCipherFactory().createEncipher(cipherParameter);
    }

    public void flush() throws IOException {
        this.writeFinalize();
        super.flush();
    }

    public ICipherFactory getCipherFactory() {
        return this.cipherFactory;
    }

    public IByteProvider getIvProvider() {
        return this.ivProvider;
    }

    public IByteProvider getKeyProvider() {
        return this.keyProvider;
    }

    public long getLength() throws IOException {
        long tmpLength = super.getLength();
        if (this.localOffset > tmpLength) {
            return this.localOffset;
        }
        return tmpLength;
    }

    public long getOffset() throws IOException {
        return this.localOffset;
    }

    protected void prepareOperation() throws IOException {
        long blockCount = this.localOffset / (long)this.blockSize;
        System.arraycopy(this.getIvProvider().getBytes(), 0, this.ivBytes, 0, this.ivBytes.length);
        ByteArrayTools.writeBigEndian((byte[])this.ivBytes, (int)12, (int)((int)blockCount), (int)4);
    }

    public int read(byte[] buffer, int start, int numBytes) throws IOException {
        this.writeFinalize();
        int offsetModulo = (int)(this.localOffset % (long)this.blockSize);
        long realOffset = (int)(this.localOffset - (long)offsetModulo);
        this.prepareOperation();
        try {
            Cipher cipher = this.createDecipher(this.createCipherParameter(this.ivBytes));
            RandomAccessInputStream is = new RandomAccessInputStream(this.randomAccess, realOffset);
            CipherInputStream cis = new CipherInputStream((InputStream)is, cipher);
            for (int i = 0; i < offsetModulo; ++i) {
                ((InputStream)cis).read();
            }
            int count = StreamTools.read((InputStream)cis, (byte[])buffer, (int)start, (int)numBytes);
            this.localOffset += (long)count;
            return count;
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public void seek(long offset) throws IOException {
        if (offset < 0L) {
            throw new IOException("negative offset");
        }
        this.localOffset = offset;
    }

    public void seekBy(long delta) throws IOException {
        this.localOffset += delta;
    }

    public void setLength(long newLength) throws IOException {
        if (newLength < this.localOffset) {
            this.localOffset = newLength;
        }
        super.setLength(newLength);
    }

    public void write(byte[] buffer, int start, int numBytes) throws IOException {
        int offsetModulo = (int)(this.localOffset % (long)this.blockSize);
        long realOffset = (int)(this.localOffset - (long)offsetModulo);
        try {
            if (this.localOffset != this.localWritePosition) {
                this.writeFinalize();
            }
            if (this.encipher == null) {
                this.prepareOperation();
                this.encipher = this.createEncipher(this.createCipherParameter(this.ivBytes));
                this.randomOutputStream = new RandomAccessOutputStream(this.randomAccess, this.localOffset);
                this.hideOutputStream = new HideOutputStream(this.randomOutputStream, realOffset, this.localOffset);
                this.cipherOutputStream = new CipherOutputStream(this.hideOutputStream, this.encipher);
                for (int i = 0; i < offsetModulo; ++i) {
                    this.cipherOutputStream.write(0);
                }
            }
            this.cipherOutputStream.write(buffer, start, numBytes);
            this.localOffset += (long)numBytes;
            this.localWritePosition = this.localOffset;
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    protected void writeFinalize() throws IOException {
        if (this.hideOutputStream != null) {
            this.hideOutputStream.setEndWritingPosition(this.localWritePosition);
        }
        StreamTools.close((Closeable)this.cipherOutputStream);
        StreamTools.close((Closeable)this.hideOutputStream);
        StreamTools.close((Closeable)this.randomOutputStream);
        this.cipherOutputStream = null;
        this.hideOutputStream = null;
        this.randomOutputStream = null;
        this.encipher = null;
    }

    static class HideOutputStream
    extends FilterOutputStream {
        private long startWritingPosition;
        private long endWritingPosition = Long.MAX_VALUE;
        private long current;

        public HideOutputStream(OutputStream os, long currentPosition, long startWritingPosition) {
            super(os);
            this.current = currentPosition;
            this.startWritingPosition = startWritingPosition;
        }

        public long getEndWritingPosition() {
            return this.endWritingPosition;
        }

        public long getStartWritingPosition() {
            return this.startWritingPosition;
        }

        public void setEndWritingPosition(long endWritingPosition) {
            this.endWritingPosition = endWritingPosition;
        }

        public void setStartWritingPosition(long startWritingPosition) {
            this.startWritingPosition = startWritingPosition;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int tmpOff = off;
            int tmpLen = len;
            int skip = (int)(this.startWritingPosition - this.current);
            long maxLen = this.endWritingPosition - this.current;
            this.current += (long)len;
            if (skip > 0) {
                tmpOff += skip;
                tmpLen -= skip;
            }
            if ((long)tmpLen > maxLen) {
                tmpLen = (int)maxLen;
            }
            if (tmpLen > 0) {
                this.out.write(b, tmpOff, tmpLen);
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.current >= this.startWritingPosition && this.current < this.endWritingPosition) {
                this.out.write(b);
            }
            ++this.current;
        }
    }
}

