/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.bytes;

import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.crypto.api.IByteStreamProvider;
import de.intarsys.tools.crypto.bytes.StaticValueProvider;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class StaticByteProvider
extends StaticValueProvider
implements IByteProvider,
IByteStreamProvider {
    private byte[] bytes;

    public StaticByteProvider() {
    }

    public StaticByteProvider(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    @Override
    public byte[] getBytes(int length) {
        if (this.bytes == null || this.bytes.length < length) {
            throw new IllegalArgumentException("byte source too small (require " + length + ")");
        }
        return ByteArrayTools.copy((byte[])this.bytes, (int)0, (int)length);
    }

    @PostConstruct
    public void init() {
        String text = this.getProperty(this.getPropertyText());
        String hex = this.getProperty(this.getPropertyHex());
        String file = this.getProperty(this.getPropertyFile());
        if (!StringTools.isEmpty((String)text)) {
            this.bytes = text.getBytes(StandardCharsets.UTF_8);
        } else if (!StringTools.isEmpty((String)hex)) {
            this.bytes = HexTools.hexStringToBytes((String)hex);
        } else {
            if (!StringTools.isEmpty((String)file)) {
                try {
                    this.bytes = FileTools.getBytes((File)new File(file));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("byte retrieval failed", e);
                }
            }
            text = this.getText();
            hex = this.getHex();
            file = this.getFile();
            if (!StringTools.isEmpty((String)text)) {
                this.bytes = text.getBytes(StandardCharsets.UTF_8);
            } else if (!StringTools.isEmpty((String)hex)) {
                this.bytes = HexTools.hexStringToBytes((String)hex);
            } else if (!StringTools.isEmpty((String)file)) {
                try {
                    this.bytes = FileTools.getBytes((File)new File(file));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("byte retrieval failed", e);
                }
            }
        }
        if (this.bytes == null) {
            throw new IllegalArgumentException("input missing");
        }
    }
}

