/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation;

import java.util.Arrays;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.qualified.QCStatement;

public enum QCType {
    esign(QCStatement.id_etsi_qct_esign),
    eseal(QCStatement.id_etsi_qct_eseal),
    web(QCStatement.id_etsi_qct_web);

    private ASN1ObjectIdentifier oid;

    public static QCType ofOid(ASN1ObjectIdentifier oid) {
        return Arrays.stream(QCType.values()).filter(e -> e.getOid().equals((ASN1Primitive)oid)).findFirst().orElse(null);
    }

    private QCType(ASN1ObjectIdentifier oid) {
        this.oid = oid;
    }

    public ASN1ObjectIdentifier getOid() {
        return this.oid;
    }
}

