/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.validation;

import de.intarsys.security.validation.IValidationAspect;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.security.validation.IValidationTarget;
import de.intarsys.tools.attribute.IAttributeSupport;
import java.util.Date;
import java.util.List;
import java.util.Set;

public interface IValidationState
extends IAttributeSupport {
    public static final int STATE_UNDEFINED = -1;
    public static final int STATE_VALID = 0;
    public static final int STATE_UNKNOWN = 2;
    public static final int STATE_INVALID = 3;
    public static final int SEVERITY_ERROR = 0;
    public static final int SEVERITY_WARNING = 1;
    public static final int SEVERITY_INFO = 2;

    public static String getSeverityLabel(int severity) {
        switch (severity) {
            case 0: {
                return "error";
            }
            case 1: {
                return "warning";
            }
            case 2: {
                return "info";
            }
        }
        return "?";
    }

    public static String getStateLabel(int state) {
        switch (state) {
            case 0: {
                return "valid";
            }
            case 2: {
                return "unknown";
            }
            case 3: {
                return "invalid";
            }
            case -1: {
                return "undefined";
            }
        }
        return "?";
    }

    public Set<Object> getAdditionalInfoObjects();

    public IValidationAspect getAspect(String var1);

    public List<IValidationAspect> getAspects();

    public List<IValidationMessage> getMessages();

    public int getSeverity();

    public int getState();

    public IValidationTarget getValidationTarget();

    public Date getValidationTime();

    public boolean isInvalid();

    public boolean isUndefined();

    public boolean isUnknown();

    public boolean isValid();
}

