/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.string.IPrettyPrintable;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.Date;

public class ValidationMessage
implements IValidationMessage,
IPrettyPrintable {
    private int level = -1;
    private String text;
    private IMessage textMessage;
    private Date timestamp;
    private final Throwable errorCause;

    public static IValidationMessage createError(IMessage textMessage) {
        return new ValidationMessage(0, textMessage);
    }

    public static IValidationMessage createError(IMessage textMessage, Throwable cause) {
        return new ValidationMessage(0, textMessage, cause);
    }

    public static IValidationMessage createError(String text) {
        return new ValidationMessage(0, text);
    }

    public static IValidationMessage createError(String text, Throwable cause) {
        return new ValidationMessage(0, text, cause);
    }

    public static IValidationMessage createInfo(IMessage textMessage) {
        return new ValidationMessage(2, textMessage);
    }

    public static IValidationMessage createInfo(String text) {
        return new ValidationMessage(2, text);
    }

    public static IValidationMessage createWarning(IMessage textMessage) {
        return new ValidationMessage(1, textMessage);
    }

    public static IValidationMessage createWarning(String text) {
        return new ValidationMessage(1, text);
    }

    public ValidationMessage(int level, IMessage textMessage) {
        this(level, textMessage, null);
    }

    public ValidationMessage(int level, IMessage textMessage, Throwable errorCause) {
        this.level = level;
        this.textMessage = textMessage;
        this.errorCause = errorCause;
        this.timestamp = DateEnvironment.get().now();
    }

    public ValidationMessage(int level, String text) {
        this(level, text, null);
    }

    public ValidationMessage(int level, String text, Throwable errorCause) {
        this.level = level;
        this.text = text;
        this.errorCause = errorCause;
        this.timestamp = DateEnvironment.get().now();
    }

    @Override
    public Throwable getErrorCause() {
        return this.errorCause;
    }

    @Override
    public int getSeverity() {
        return this.level;
    }

    public String getSeverityLabel() {
        switch (this.level) {
            case 0: {
                return "ERROR";
            }
            case 1: {
                return "WARN";
            }
            case 2: {
                return "INFO";
            }
        }
        return "?";
    }

    @Override
    public String getText() {
        if (this.text == null) {
            return this.textMessage == null ? null : this.textMessage.getString();
        }
        return this.text;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isError() {
        return this.getSeverity() == 0;
    }

    @Override
    public boolean isInfo() {
        return this.getSeverity() == 2;
    }

    @Override
    public boolean isWarning() {
        return this.getSeverity() == 1;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void toString(PrettyPrinter printer) {
        printer.appendValue((Object)this.getSeverityLabel());
        printer.appendValue((Object)":");
        printer.appendValue((Object)this.getText());
    }
}

