/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.standard.validation.VSCertificate;
import de.intarsys.security.standard.validation.VSSignature;
import de.intarsys.security.standard.validation.VSSignatureContainerEntry;
import de.intarsys.security.standard.validation.VTSignatureEntry;
import de.intarsys.security.timestamp.ITimestampInfo;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSQualification;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.IValidationTarget;
import de.intarsys.security.validation.QCType;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.string.PrettyPrinter;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class VSSignatureEntry
extends VSSignatureContainerEntry
implements IVSSignatureEntry {
    private IVSCertificate certificateState;
    private List<IVSTimestamp> timestampStates;
    private IVSSignature signatureState;
    private List<IVSCertificate> attributeCertificateStates;
    private IVSQualification qualificationState;

    public VSSignatureEntry() {
        this.timestampStates = new ArrayList<IVSTimestamp>();
        this.attributeCertificateStates = new ArrayList<IVSCertificate>();
    }

    public VSSignatureEntry(ISignatureEntry signatureEntry) {
        super(new VTSignatureEntry(signatureEntry));
        this.timestampStates = new ArrayList<IVSTimestamp>();
        this.attributeCertificateStates = new ArrayList<IVSCertificate>();
    }

    public VSSignatureEntry(ISignatureEntry signatureEntry, int state) {
        super((IValidationTarget)new VTSignatureEntry(signatureEntry), state);
        this.timestampStates = new ArrayList<IVSTimestamp>();
        this.attributeCertificateStates = new ArrayList<IVSCertificate>();
    }

    public VSSignatureEntry(ISignatureEntry signatureEntry, IValidationState state) {
        super((IValidationTarget)new VTSignatureEntry(signatureEntry), state);
    }

    public void addAttributeCertificateState(IVSCertificate pCertificateState) {
        this.attributeCertificateStates.add(pCertificateState);
        this.increaseState(pCertificateState);
    }

    public void addTimestampState(IVSTimestamp timestampState) {
        this.timestampStates.add(timestampState);
        this.increaseState(timestampState);
    }

    @Override
    protected void copy(IValidationState state) {
        super.copy(state);
        IVSSignatureEntry entryState = (IVSSignatureEntry)state;
        this.certificateState = entryState.getCertificateState();
        this.timestampStates = entryState.getTimestampStates();
        this.signatureState = entryState.getSignatureState();
        this.attributeCertificateStates = entryState.getAttributeCertificateStates();
        this.qualificationState = entryState.getQualificationState();
    }

    @Override
    public List<IVSCertificate> getAttributeCertificateStates() {
        return this.attributeCertificateStates;
    }

    @Override
    public IVSCertificate getCertificateState() {
        if (this.certificateState == null) {
            ISignatureEntry entry = ((VTSignatureEntry)this.getValidationTarget()).getSignatureEntry();
            IX509PublicKeyCertificate certificate = null;
            try {
                certificate = entry.getSignerCertificate();
            }
            catch (CertificateException certificateException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.certificateState = new VSCertificate(certificate);
        }
        return this.certificateState;
    }

    @Override
    public Date getCreationDate() {
        Date tsDate;
        ITimestampInfo timestampInfo = this.getFirstValidTimestamp();
        if (timestampInfo != null && (tsDate = timestampInfo.getGenTime()) != null) {
            return tsDate;
        }
        Date date = this.getEntry().getCreationDate();
        if (date != null) {
            return date;
        }
        return null;
    }

    @Override
    public String getCreationDateSource() {
        Date tsDate;
        ITimestampInfo timestampInfo = this.getFirstValidTimestamp();
        if (timestampInfo != null && (tsDate = timestampInfo.getGenTime()) != null) {
            return "timestamp";
        }
        Date date = this.getEntry().getSigningTime();
        if (date != null) {
            return "signature";
        }
        return "node";
    }

    @Override
    public ISignatureEntry getEntry() {
        return ((VTSignatureEntry)this.getValidationTarget()).getSignatureEntry();
    }

    protected ITimestampInfo getFirstValidTimestamp() {
        if (this.getTimestampStates() != null) {
            for (IVSTimestamp tsState : this.getTimestampStates()) {
                ITimestampToken ts;
                if (!tsState.isValid() || (ts = tsState.getTimestamp()) == null) continue;
                try {
                    return ts.getTimestampInfo();
                }
                catch (IOException iOException) {
                }
            }
        }
        return null;
    }

    @Override
    public IVSQualification getQualificationState() {
        return this.qualificationState;
    }

    @Override
    public Date getReferenceDate() {
        if (this.getCertificateState() == null) {
            return null;
        }
        return this.getCertificateState().getReferenceDate();
    }

    @Override
    public String getSignatureLevel() {
        if (this.getQualificationState() != null && this.getQualificationState().isValid()) {
            return "qualified";
        }
        return "simple/advanced";
    }

    @Override
    public IVSSignature getSignatureState() {
        if (this.signatureState == null) {
            this.signatureState = new VSSignature((IDigest)null);
        }
        return this.signatureState;
    }

    @Override
    public String getSignatureType() {
        if (this.getQualificationState() == null) {
            return "personal";
        }
        List qcTypes = Optional.ofNullable(this.getQualificationState().getQcInfo()).map(qci -> qci.getQcTypes()).orElseGet(() -> Collections.emptyList());
        if (qcTypes.isEmpty()) {
            return "personal";
        }
        if (qcTypes.contains((Object)QCType.esign)) {
            return "personal";
        }
        if (qcTypes.contains((Object)QCType.eseal)) {
            return "seal";
        }
        return "other";
    }

    @Override
    public List<IVSTimestamp> getTimestampStates() {
        return this.timestampStates;
    }

    @Override
    public boolean isRecoverable() {
        if (!this.isUnknown()) {
            return false;
        }
        if (!this.isRecoverable(this.getSignatureState())) {
            return false;
        }
        if (!this.isRecoverable(this.getCertificateState())) {
            return false;
        }
        for (IVSCertificate attrCertificateState : this.getAttributeCertificateStates()) {
            if (this.isRecoverable(attrCertificateState)) continue;
            return false;
        }
        for (IVSTimestamp timestampState : this.getTimestampStates()) {
            if (this.isRecoverable(timestampState)) continue;
            return false;
        }
        return this.isRecoverable(this.getQualificationState());
    }

    public void setAttributeCertificateStates(List<IVSCertificate> states) {
        for (IVSCertificate certState : states) {
            this.addAttributeCertificateState(certState);
        }
    }

    public void setCertificateState(IVSCertificate pCertificateState) {
        this.certificateState = pCertificateState;
        this.increaseState(this.certificateState);
    }

    public void setQualificationState(IVSQualification pQualificationState) {
        this.qualificationState = pQualificationState;
        this.increaseState(this.qualificationState);
    }

    public void setSignatureState(IVSSignature pSignatureState) {
        this.signatureState = pSignatureState;
        this.increaseState(this.signatureState);
    }

    public void setTimestampStates(List<IVSTimestamp> states) {
        for (IVSTimestamp tsState : states) {
            this.addTimestampState(tsState);
        }
    }

    @Override
    public void toString(PrettyPrinter printer) {
        super.toString(printer);
        printer.appendMember("referenceDate", (Object)this.getReferenceDate(), null);
        printer.appendMember("creationDate", (Object)this.getCreationDate(), null);
        printer.appendMember("creationDateSource", (Object)this.getCreationDateSource(), null);
        printer.appendMember("signatureLevel", (Object)this.getSignatureLevel(), null);
        printer.appendMember("signatureState", (Object)this.getSignatureState(), null);
        printer.appendMember("certificateState", (Object)this.getCertificateState(), null);
        printer.appendMember("qualificationState", (Object)this.getQualificationState(), null);
        if (this.getTimestampStates().size() > 0) {
            printer.appendMember("timestampStates", this.getTimestampStates(), null);
        }
    }
}

