/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.ssl;

import de.intarsys.security.app.validation.EnumKeyPurpose;
import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.app.validation.commonpki.CommonPKIValidationContextFactory;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.CollectionCertificateProvider;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.provider.CertificateProvider;
import de.intarsys.security.certificate.provider.CompositeCertificateProvider;
import de.intarsys.security.certificate.provider.standard.TrustedCertificateProvider;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonTrustManager
implements X509TrustManager {
    private static final Logger Log = LoggerFactory.getLogger(CommonTrustManager.class);
    private static final String AUTHTYPE_RSA = "RSA";

    protected CommonTrustManager() {
    }

    protected abstract void acceptCertificate(IX509PublicKeyCertificate[] var1, IVSCertificate var2) throws CertificateException;

    @Override
    public void checkClientTrusted(X509Certificate[] path, String authType) throws CertificateException {
        this.checkTrusted(path, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] path, String authType) throws CertificateException {
        this.checkTrusted(path, authType);
    }

    protected void checkTrusted(X509Certificate[] jPath, String authType) throws CertificateException {
        IX509PublicKeyCertificate[] path = CertificateTools.wrapJavaCerts(jPath);
        IVSCertificate certificateState = this.validateCertificate(path);
        this.acceptCertificate(path, certificateState);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509CertificateSelector filter = new X509CertificateSelector();
        filter.setAcceptAttributeCertificates(false);
        Iterator<IX509Certificate> iCerts = TrustedCertificateProvider.get().lookupCertificates(filter);
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        while (iCerts.hasNext()) {
            IX509PublicKeyCertificate cert = (IX509PublicKeyCertificate)iCerts.next();
            try {
                certs.add(cert.toJavaCertificate());
            }
            catch (CertificateException e) {
                Log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IVSCertificate validateCertificate(IX509PublicKeyCertificate[] path) {
        IX509PublicKeyCertificate certificate = path[0];
        Args args = Args.create();
        args.put("stopOnIntermediateTrustAnchor", (Object)true);
        args.put("checkCRL", (Object)false);
        args.put("checkOCSP", (Object)false);
        IValidationContext previousContext = ValidationContext.getCurrent();
        IValidationContext context = CommonPKIValidationContextFactory.get().createValidationContext((IArgs)args);
        try {
            ValidationParameters params = new ValidationParameters();
            params.setKeyPurpose(EnumKeyPurpose.SERVERAUTHENTICATION);
            params.setTrustedCerts(TrustedCertificateProvider.get());
            CompositeCertificateProvider additionalCertificates = new CompositeCertificateProvider();
            additionalCertificates.registerCertificateProvider(new CollectionCertificateProvider(Arrays.asList(path)));
            additionalCertificates.registerCertificateProvider(CertificateProvider.get());
            params.setAdditionalCerts(additionalCertificates);
            IVSCertificate iVSCertificate = context.getCertificateValidator().validate(certificate, params);
            return iVSCertificate;
        }
        finally {
            ValidationContext.setCurrent(previousContext);
        }
    }
}

