/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.ssl;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.CertificateProviderTools;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.ssl.KeyManagerTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.ssl.IKeyManagerProvider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.function.Function;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateBasedKeyManagerProvider
implements IKeyManagerProvider {
    private static final Logger Log = LoggerFactory.getLogger(CertificateBasedKeyManagerProvider.class);
    private ICertificateProvider certificateProvider;
    private IX509PublicKeyCertificate certificate;
    private Object selector;
    private Secret keyPassword;
    private Function<IX509PublicKeyCertificate, Secret> keyPasswordProvider;

    public KeyManager[] createKeyManagers() throws GeneralSecurityException, IOException {
        IX509PublicKeyCertificate certificate = this.getOrCreateCertificate();
        if (certificate == null) {
            throw new IllegalArgumentException("certificate not found or invalid");
        }
        Secret tmpPassword = this.getKeyPassword();
        if (tmpPassword == null && this.getKeyPasswordProvider() != null) {
            tmpPassword = this.getKeyPasswordProvider().apply(certificate);
        }
        return KeyManagerTools.createKeyManagers(certificate, tmpPassword);
    }

    public IX509PublicKeyCertificate getCertificate() {
        return this.certificate;
    }

    public ICertificateProvider getCertificateProvider() {
        return this.certificateProvider;
    }

    public Secret getKeyPassword() {
        return this.keyPassword;
    }

    public Function<IX509PublicKeyCertificate, Secret> getKeyPasswordProvider() {
        return this.keyPasswordProvider;
    }

    protected IX509PublicKeyCertificate getOrCreateCertificate() throws IOException {
        if (this.getCertificate() != null) {
            return this.getCertificate();
        }
        try {
            return (IX509PublicKeyCertificate)CertificateProviderTools.lookupCertificate(this.getCertificateProvider(), this.getSelector());
        }
        catch (ObjectCreationException e) {
            throw new IOException("cannot find certificate", e);
        }
    }

    public Object getSelector() {
        return this.selector;
    }

    public void setCertificate(IX509PublicKeyCertificate certificate) {
        this.certificate = certificate;
    }

    public void setCertificateProvider(ICertificateProvider certificateProvider) {
        this.certificateProvider = certificateProvider;
    }

    public void setKeyPassword(Secret keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setKeyPasswordProvider(Function<IX509PublicKeyCertificate, Secret> keyPasswordProvider) {
        this.keyPasswordProvider = keyPasswordProvider;
    }

    public void setSelector(Object selector) {
        this.selector = selector;
    }
}

