/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature.policy.asn1;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.policy.SignPolExtensions;
import de.intarsys.asn1.policy.SignPolicyInfo;
import de.intarsys.asn1.policy.SignaturePolicy;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.signature.policy.EmptyExtensions;
import de.intarsys.security.signature.policy.IAutomationPolicy;
import de.intarsys.security.signature.policy.IExtension;
import de.intarsys.security.signature.policy.IExtensionSupport;
import de.intarsys.security.signature.policy.ISignatureValidationPolicy;
import de.intarsys.security.signature.policy.asn1.ASN1Extensions;
import de.intarsys.security.signature.policy.asn1.ASN1SignatureValidationPolicy;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;

public class ASN1SignaturePolicy
implements IAutomationPolicy {
    private SignaturePolicy impl;
    private SignPolicyInfo signPolicyInfo;
    private IExtensionSupport extensionSupport;
    private X500Principal issuerX500Principal;
    private ISignatureValidationPolicy signatureValidationPolicy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IAutomationPolicy create(ILocator locator) throws IOException {
        InputStream in = null;
        try {
            in = locator.getInputStream();
            ASN1Primitive asn1 = ASN1Tools.create((InputStream)in);
            SignaturePolicy signaturePolicy = (SignaturePolicy)SignaturePolicy.FACTORY.create((ASN1Encodable)asn1);
            ASN1SignaturePolicy aSN1SignaturePolicy = new ASN1SignaturePolicy(signaturePolicy);
            return aSN1SignaturePolicy;
        }
        finally {
            StreamTools.close((Closeable)in);
        }
    }

    public ASN1SignaturePolicy(SignaturePolicy impl) throws IOException {
        this.impl = impl;
        this.signPolicyInfo = impl.getSignPolicyInfo();
        this.issuerX500Principal = CertificateTools.parsePrincipal(this.getSignPolicyInfo().getPolicyIssuerName());
        this.signatureValidationPolicy = new ASN1SignatureValidationPolicy(this.signPolicyInfo.getSignatureValidationPolicy());
        SignPolExtensions signPolExtensions = this.getSignPolicyInfo().getSignPolExtensions();
        this.extensionSupport = signPolExtensions == null ? new EmptyExtensions() : new ASN1Extensions(signPolExtensions);
    }

    @Override
    public String getEncoding() {
        return "der";
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.impl.getDEREncoded();
    }

    @Override
    public String getOID() {
        return this.getSignPolicyInfo().getSignPolicyIdentifier();
    }

    public SignPolicyInfo getSignPolicyInfo() {
        return this.signPolicyInfo;
    }

    public SignaturePolicy getImpl() {
        return this.impl;
    }

    @Override
    public Date getDateOfIssue() {
        return this.getSignPolicyInfo().getDateOfIssue();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.issuerX500Principal;
    }

    @Override
    public String getFieldOfApplication() {
        return this.getSignPolicyInfo().getFieldOfApplication();
    }

    @Override
    public ISignatureValidationPolicy getSignatureValidationPolicy() {
        return this.signatureValidationPolicy;
    }

    protected IExtensionSupport getExtensionSupport() {
        return this.extensionSupport;
    }

    @Override
    public IExtension getExtension(String oid) {
        return this.getExtensionSupport().getExtension(oid);
    }

    @Override
    public IExtension[] getExtensions() {
        return this.getExtensionSupport().getExtensions();
    }
}

