/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature;

import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.tools.attribute.Attribute;

public class CommonSignatureEntryAttributes {
    public static final Attribute XML_SIGNATUREVALUE_ID = new Attribute("xmlSignatureValueId");
    public static final Attribute XML_SIGNATUREELEMENT_XPATH = new Attribute("xmlSignatureElementXPath");
    public static final Attribute BINARY_SIGNATURE_OFFSET = new Attribute("binarySignatureOffset");
    public static final Attribute PDF_SIGNATUREFIELDNAME = new Attribute("pdfSignatureFieldName");
    public static final Attribute PDF_SIGNATUREVISIBLE = new Attribute("pdfSignatureVisible");

    public static String getPDFFieldName(ISignatureEntry signatureEntry) {
        return (String)signatureEntry.getAttribute(PDF_SIGNATUREFIELDNAME);
    }

    public static String getXMLSignatureElementXPath(ISignatureEntry signatureEntry) {
        return (String)signatureEntry.getAttribute(XML_SIGNATUREELEMENT_XPATH);
    }

    public static String getXMLSignatureValueId(ISignatureEntry signatureEntry) {
        return (String)signatureEntry.getAttribute(XML_SIGNATUREVALUE_ID);
    }

    public static boolean isPDFSignatureVisible(ISignatureEntry signatureEntry) {
        Boolean visible = (Boolean)signatureEntry.getAttribute(PDF_SIGNATUREVISIBLE);
        if (visible == null) {
            return false;
        }
        return visible;
    }

    public static String setPDFFieldName(ISignatureEntry signatureEntry, String fieldName) {
        return (String)signatureEntry.setAttribute(PDF_SIGNATUREFIELDNAME, fieldName);
    }

    public static boolean setPDFSignatureVisible(ISignatureEntry signatureEntry, boolean visible) {
        Boolean oldVisible = (Boolean)signatureEntry.setAttribute(PDF_SIGNATUREVISIBLE, visible);
        if (oldVisible == null) {
            return false;
        }
        return oldVisible;
    }

    public static String setXMLSignatureElementXPath(ISignatureEntry signatureEntry, String xPath) {
        return (String)signatureEntry.setAttribute(XML_SIGNATUREELEMENT_XPATH, xPath);
    }

    public static String setXMLSignatureValueId(ISignatureEntry signatureEntry, String id) {
        return (String)signatureEntry.setAttribute(XML_SIGNATUREVALUE_ID, id);
    }

    private CommonSignatureEntryAttributes() {
    }
}

