/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.openssl;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.openssl.PEMUtil;
import de.intarsys.tools.crypto.Secret;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemGenerationException;
import org.bouncycastle.util.io.pem.PemHeader;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class PEMPrivateKeyGenerator
implements PemObjectGenerator {
    private PrivateKey privateKey;
    private String algorithm;
    private Secret password;
    private SecureRandom random;
    private String provider = "BC";

    public PEMPrivateKeyGenerator(KeyPair keyPair, String algorithm, Secret password, SecureRandom random) {
        this.privateKey = keyPair.getPrivate();
        this.algorithm = algorithm;
        this.password = password;
        this.random = random;
    }

    public PEMPrivateKeyGenerator(PrivateKey privateKey, String algorithm, Secret password, SecureRandom random) {
        this.privateKey = privateKey;
        this.algorithm = algorithm;
        this.password = password;
        this.random = random;
    }

    public PemObject generate() throws PemGenerationException {
        try {
            String type = null;
            ArrayList<PemHeader> headers = new ArrayList<PemHeader>();
            byte[] content = null;
            byte[] keyData = null;
            if (this.getPrivateKey() instanceof RSAPrivateCrtKey) {
                type = "RSA PRIVATE KEY";
                k = (RSAPrivateCrtKey)this.getPrivateKey();
                RSAPrivateKeyStructure keyStruct = new RSAPrivateKeyStructure(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
                keyData = keyStruct.getEncoded();
            } else if (this.getPrivateKey() instanceof DSAPrivateKey) {
                type = "DSA PRIVATE KEY";
                k = (DSAPrivateKey)this.getPrivateKey();
                DSAParams p = k.getParams();
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add((ASN1Encodable)new ASN1Integer(0L));
                v.add((ASN1Encodable)new ASN1Integer(p.getP()));
                v.add((ASN1Encodable)new ASN1Integer(p.getQ()));
                v.add((ASN1Encodable)new ASN1Integer(p.getG()));
                BigInteger x = k.getX();
                BigInteger y = p.getG().modPow(x, p.getP());
                v.add((ASN1Encodable)new ASN1Integer(y));
                v.add((ASN1Encodable)new ASN1Integer(x));
                keyData = new DERSequence(v).getEncoded();
            } else if ("ECDSA".equals(this.getPrivateKey().getAlgorithm())) {
                type = "EC PRIVATE KEY";
                PrivateKeyInfo privInfo = PrivateKeyInfo.getInstance((Object)ASN1Tools.create((byte[])this.getPrivateKey().getEncoded()));
                keyData = privInfo.parsePrivateKey().toASN1Primitive().getEncoded();
            }
            if (type == null || keyData == null) {
                throw new IllegalArgumentException("Object type not supported: " + this.getPrivateKey().getClass().getName());
            }
            String dekAlgName = Strings.toUpperCase((String)this.algorithm);
            if (dekAlgName.equals("DESEDE")) {
                dekAlgName = "DES-EDE3-CBC";
            }
            int ivLength = dekAlgName.startsWith("AES-") ? 16 : 8;
            byte[] iv = new byte[ivLength];
            this.random.nextBytes(iv);
            content = PEMUtil.crypt(true, this.provider, keyData, this.password, dekAlgName, iv);
            headers.add(new PemHeader("Proc-Type", "4,ENCRYPTED"));
            headers.add(new PemHeader("DEK-Info", dekAlgName + "," + new String(Hex.encode((byte[])iv))));
            PemObject pemObject = new PemObject(type, headers, content);
            return pemObject;
        }
        catch (IOException e) {
            throw new PemGenerationException(e.getMessage(), (Throwable)e);
        }
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

