/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.openssl;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.io.pem.PemGenerationException;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class PEMCertificateGenerator
implements PemObjectGenerator {
    private X509Certificate certificate;

    public PEMCertificateGenerator(IX509PublicKeyCertificate certificate) {
        try {
            this.certificate = certificate.toJavaCertificate();
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public PEMCertificateGenerator(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public PemObject generate() throws PemGenerationException {
        byte[] content;
        try {
            content = this.getCertificate().getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new PemGenerationException(e.getMessage(), (Throwable)e);
        }
        PemObject pemObject = new PemObject("CERTIFICATE", content);
        return pemObject;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }
}

