/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.ocsp.common;

import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.common.OCSPResponse;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import org.bouncycastle.asn1.ocsp.ResponseBytes;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class OCSPTools {
    public static org.bouncycastle.asn1.ocsp.OCSPResponse asAsn1OcspResponse(IOCSPResponse ocspResponse) throws IOException {
        ResponseBytes responseBytes = new ResponseBytes(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1.1"), (ASN1OctetString)new DEROctetString(ocspResponse.getEncoded()));
        org.bouncycastle.asn1.ocsp.OCSPResponse ocspResponseWrapper = new org.bouncycastle.asn1.ocsp.OCSPResponse(new OCSPResponseStatus(0), responseBytes);
        return ocspResponseWrapper;
    }

    public static IOCSPResponse decodeOCSPResponse(byte[] bOcspResponse) {
        org.bouncycastle.asn1.ocsp.OCSPResponse ocspResponse = org.bouncycastle.asn1.ocsp.OCSPResponse.getInstance((Object)bOcspResponse);
        return OCSPTools.decodeOCSPResponse(ocspResponse);
    }

    public static IOCSPResponse decodeOCSPResponse(org.bouncycastle.asn1.ocsp.OCSPResponse ocspResponse) {
        byte[] encBasicOCSPResp = ocspResponse.getResponseBytes().getResponse().getOctets();
        OCSPResponse resultResponse = new OCSPResponse(new BasicOCSPResp(BasicOCSPResponse.getInstance((Object)encBasicOCSPResp)));
        return resultResponse;
    }

    public static byte[] encodeAsn1OcspResponse(IOCSPResponse ocspResponse) throws IOException {
        return OCSPTools.asAsn1OcspResponse(ocspResponse).getEncoded();
    }

    private OCSPTools() {
    }
}

