/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.ldap;

import java.net.URISyntaxException;

public class LDAPAddress {
    private String baseDN;
    private String host;
    private int port = -1;

    public static LDAPAddress parse(String url) throws URISyntaxException {
        if (url == null) {
            throw new URISyntaxException(url, "url must not be null");
        }
        if (!url.startsWith("ldap://")) {
            throw new URISyntaxException(url, "url must start with ldap://");
        }
        String remaining = url.substring(7);
        int pathDelimiter = remaining.indexOf("/");
        String address = null;
        String baseDN = null;
        if (pathDelimiter > -1) {
            address = remaining.substring(0, pathDelimiter);
            baseDN = remaining.substring(pathDelimiter + 1);
        } else {
            address = remaining;
        }
        int portDelimiter = address.indexOf(":");
        String host = null;
        String port = null;
        if (portDelimiter > -1) {
            host = address.substring(0, portDelimiter);
            port = address.substring(portDelimiter + 1);
        } else {
            host = address;
        }
        if (host == null || host.length() == 0) {
            throw new URISyntaxException(url, "missing host");
        }
        int portNumber = 389;
        if (port != null) {
            if (port.length() == 0) {
                throw new URISyntaxException(url, "missing port");
            }
            try {
                portNumber = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                throw new URISyntaxException(url, "invalid port defiinition");
            }
        }
        return new LDAPAddress(host, portNumber, baseDN);
    }

    public LDAPAddress() {
    }

    public LDAPAddress(String host) {
        this.host = host;
    }

    public LDAPAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public LDAPAddress(String host, int port, String baseDN) {
        this.host = host;
        this.port = port;
        this.baseDN = baseDN;
    }

    public LDAPAddress(String host, String baseDN) {
        this.host = host;
        this.baseDN = baseDN;
    }

    public Object clone() {
        LDAPAddress copy = new LDAPAddress();
        copy.setHost(this.host);
        copy.setPort(this.port);
        copy.setBaseDN(this.baseDN);
        return copy;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        if (this.port < 0) {
            return 389;
        }
        return this.port;
    }

    public String getUrl() {
        String url = "ldap://" + this.getHost() + ":" + this.getPort();
        if (this.getBaseDN() != null) {
            url = url + "/" + this.getBaseDN();
        }
        return url;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

